/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.JdkSslServerContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.testsuite.transport.AbstractComboTestsuiteTest;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.security.cert.CertificateException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSessionContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.api.Timeout;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class SocketSslSessionReuseTest
extends AbstractSocketTest {
    private static final InternalLogger logger;
    private static final File CERT_FILE;
    private static final File KEY_FILE;

    public static Collection<Object[]> data() throws Exception {
        return Collections.singletonList(new Object[]{new JdkSslServerContext(CERT_FILE, KEY_FILE), new JdkSslClientContext(CERT_FILE)});
    }

    @ParameterizedTest(name="{index}: serverEngine = {0}, clientEngine = {1}")
    @MethodSource(value={"data"})
    @Timeout(value=30000L, unit=TimeUnit.MILLISECONDS)
    public void testSslSessionReuse(final SslContext serverCtx, final SslContext clientCtx, TestInfo testInfo) throws Throwable {
        this.run(testInfo, new AbstractComboTestsuiteTest.Runner<ServerBootstrap, Bootstrap>(){

            @Override
            public void run(ServerBootstrap serverBootstrap, Bootstrap bootstrap) throws Throwable {
                SocketSslSessionReuseTest.this.testSslSessionReuse((ServerBootstrap)SocketSslSessionReuseTest.this.sb, (Bootstrap)SocketSslSessionReuseTest.this.cb, serverCtx, clientCtx);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSslSessionReuse(ServerBootstrap sb, Bootstrap cb, final SslContext serverCtx, final SslContext clientCtx) throws Throwable {
        final ReadAndDiscardHandler sh = new ReadAndDiscardHandler(true, true);
        final ReadAndDiscardHandler ch = new ReadAndDiscardHandler(false, true);
        final String[] protocols = new String[]{"TLSv1", "TLSv1.1", "TLSv1.2"};
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel sch) throws Exception {
                SSLEngine engine = serverCtx.newEngine(sch.alloc());
                engine.setUseClientMode(false);
                engine.setEnabledProtocols(protocols);
                sch.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
                sch.pipeline().addLast(new ChannelHandler[]{sh});
            }
        });
        final Channel sc = sb.bind().sync().channel();
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            protected void initChannel(SocketChannel sch) throws Exception {
                InetSocketAddress serverAddr = (InetSocketAddress)sc.localAddress();
                SSLEngine engine = clientCtx.newEngine(sch.alloc(), serverAddr.getHostString(), serverAddr.getPort());
                engine.setUseClientMode(true);
                engine.setEnabledProtocols(protocols);
                sch.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
                sch.pipeline().addLast(new ChannelHandler[]{ch});
            }
        });
        try {
            SSLSessionContext clientSessionCtx = clientCtx.sessionContext();
            ByteBuf msg = Unpooled.wrappedBuffer((byte[])new byte[]{10, 11, 12, 13}, (int)0, (int)4);
            Channel cc = cb.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush((Object)msg).sync();
            cc.closeFuture().sync();
            SocketSslSessionReuseTest.rethrowHandlerExceptions(sh, ch);
            Set<String> sessions = SocketSslSessionReuseTest.sessionIdSet(clientSessionCtx.getIds());
            msg = Unpooled.wrappedBuffer((byte[])new byte[]{10, 11, 12, 13}, (int)0, (int)4);
            cc = cb.connect(sc.localAddress()).sync().channel();
            cc.writeAndFlush((Object)msg).sync();
            cc.closeFuture().sync();
            Assertions.assertEquals(sessions, SocketSslSessionReuseTest.sessionIdSet(clientSessionCtx.getIds()), (String)"Expected no new sessions");
            SocketSslSessionReuseTest.rethrowHandlerExceptions(sh, ch);
        }
        finally {
            sc.close().awaitUninterruptibly();
        }
    }

    private static void rethrowHandlerExceptions(ReadAndDiscardHandler sh, ReadAndDiscardHandler ch) throws Throwable {
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    private static Set<String> sessionIdSet(Enumeration<byte[]> sessionIds) {
        HashSet<String> idSet = new HashSet<String>();
        while (sessionIds.hasMoreElements()) {
            byte[] id = sessionIds.nextElement();
            idSet.add(ByteBufUtil.hexDump((ByteBuf)Unpooled.wrappedBuffer((byte[])id)));
        }
        return idSet;
    }

    static {
        SelfSignedCertificate ssc;
        logger = InternalLoggerFactory.getInstance(SocketSslSessionReuseTest.class);
        try {
            ssc = new SelfSignedCertificate();
        }
        catch (CertificateException e) {
            throw new Error(e);
        }
        CERT_FILE = ssc.certificate();
        KEY_FILE = ssc.privateKey();
    }

    @ChannelHandler.Sharable
    private static class ReadAndDiscardHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        final AtomicReference<Throwable> exception = new AtomicReference();
        private final boolean server;
        private final boolean autoRead;

        ReadAndDiscardHandler(boolean server, boolean autoRead) {
            this.server = server;
            this.autoRead = autoRead;
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            ctx.close();
        }

        public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
            try {
                ctx.flush();
            }
            finally {
                if (!this.autoRead) {
                    ctx.read();
                }
            }
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (logger.isWarnEnabled()) {
                logger.warn("Unexpected exception from the " + (this.server ? "server" : "client") + " side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

