/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.code;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.incubator.semconv.code.CodeAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.semconv.CodeAttributes;
import javax.annotation.Nullable;

public final class CodeAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final AttributeKey<String> CODE_NAMESPACE = AttributeKey.stringKey((String)"code.namespace");
    private static final AttributeKey<String> CODE_FUNCTION = AttributeKey.stringKey((String)"code.function");
    private final CodeAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(CodeAttributesGetter<REQUEST> getter) {
        return new CodeAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private CodeAttributesExtractor(CodeAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String methodName;
        StringBuilder sb = new StringBuilder();
        Class<?> cls = this.getter.getCodeClass(request);
        if (cls != null) {
            sb.append(cls.getName());
            if (SemconvStability.isEmitOldCodeSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CODE_NAMESPACE, (Object)cls.getName());
            }
        }
        if ((methodName = this.getter.getMethodName(request)) != null) {
            if (sb.length() > 0) {
                sb.append(".");
            }
            sb.append(methodName);
            if (SemconvStability.isEmitOldCodeSemconv()) {
                AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, CODE_FUNCTION, (Object)methodName);
            }
        }
        if (SemconvStability.isEmitStableCodeSemconv() && sb.length() > 0) {
            AttributesExtractorUtil.internalSet((AttributesBuilder)attributes, (AttributeKey)CodeAttributes.CODE_FUNCTION_NAME, (Object)sb.toString());
        }
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

