/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.incubator.semconv.db.internal;

import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenterBuilder;
import io.opentelemetry.instrumentation.api.incubator.semconv.db.internal.SqlCommenterUtil;
import java.util.function.BiFunction;
import java.util.function.Predicate;

public final class SqlCommenter {
    private final boolean enabled;
    private final BiFunction<Object, Boolean, TextMapPropagator> propagator;
    private final Predicate<Object> prepend;

    SqlCommenter(boolean enabled, BiFunction<Object, Boolean, TextMapPropagator> propagator, Predicate<Object> prepend) {
        this.enabled = enabled;
        this.propagator = propagator;
        this.prepend = prepend;
    }

    public static SqlCommenterBuilder builder() {
        return new SqlCommenterBuilder();
    }

    public static SqlCommenter noop() {
        return SqlCommenter.builder().build();
    }

    public String processQuery(Object connection, String sql, boolean executed) {
        if (!this.enabled) {
            return sql;
        }
        return SqlCommenterUtil.processQuery(sql, this.propagator.apply(connection, executed), this.prepend.test(connection));
    }

    public boolean isEnabled() {
        return this.enabled;
    }
}

