/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.TextMapGetter;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.instrumentation.api.InstrumentationVersion;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.ClientInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.ErrorCauseExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.ServerInstrumenter;
import io.opentelemetry.instrumentation.api.instrumenter.SpanKindExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanNameExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.SpanStatusExtractor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class InstrumenterBuilder<REQUEST, RESPONSE> {
    private final OpenTelemetry openTelemetry;
    private final String instrumentationName;
    private final SpanNameExtractor<? super REQUEST> spanNameExtractor;
    private final List<AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors = new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>();
    private SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor = SpanStatusExtractor.getDefault();
    private ErrorCauseExtractor errorCauseExtractor = ErrorCauseExtractor.jdk();

    InstrumenterBuilder(OpenTelemetry openTelemetry, String instrumentationName, SpanNameExtractor<? super REQUEST> spanNameExtractor) {
        this.openTelemetry = openTelemetry;
        this.instrumentationName = instrumentationName;
        this.spanNameExtractor = spanNameExtractor;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setSpanStatusExtractor(SpanStatusExtractor<? super REQUEST, ? super RESPONSE> spanStatusExtractor) {
        this.spanStatusExtractor = spanStatusExtractor;
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractor(AttributesExtractor<? super REQUEST, ? super RESPONSE> attributesExtractor) {
        this.attributesExtractors.add(attributesExtractor);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(Iterable<? extends AttributesExtractor<? super REQUEST, ? super RESPONSE>> attributesExtractors) {
        attributesExtractors.forEach(this.attributesExtractors::add);
        return this;
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> addAttributesExtractors(AttributesExtractor<? super REQUEST, ? super RESPONSE> ... attributesExtractors) {
        return this.addAttributesExtractors(Arrays.asList(attributesExtractors));
    }

    public InstrumenterBuilder<REQUEST, RESPONSE> setErrorCauseExtractor(ErrorCauseExtractor errorCauseExtractor) {
        this.errorCauseExtractor = errorCauseExtractor;
        return this;
    }

    public Instrumenter<REQUEST, RESPONSE> newClientInstrumenter(TextMapSetter<REQUEST> setter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingToDownstream(this.openTelemetry.getPropagators(), setter), SpanKindExtractor.alwaysClient());
    }

    public Instrumenter<REQUEST, RESPONSE> newServerInstrumenter(TextMapGetter<REQUEST> getter) {
        return this.newInstrumenter(InstrumenterConstructor.propagatingFromUpstream(this.openTelemetry.getPropagators(), getter), SpanKindExtractor.alwaysServer());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter() {
        return this.newInstrumenter(InstrumenterConstructor.internal(), SpanKindExtractor.alwaysInternal());
    }

    public Instrumenter<REQUEST, RESPONSE> newInstrumenter(SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return this.newInstrumenter(InstrumenterConstructor.internal(), spanKindExtractor);
    }

    private Instrumenter<REQUEST, RESPONSE> newInstrumenter(InstrumenterConstructor<REQUEST, RESPONSE> constructor, SpanKindExtractor<? super REQUEST> spanKindExtractor) {
        return constructor.create(this.instrumentationName, this.openTelemetry.getTracer(this.instrumentationName, InstrumentationVersion.VERSION), this.spanNameExtractor, spanKindExtractor, this.spanStatusExtractor, new ArrayList<AttributesExtractor<? super REQUEST, ? super RESPONSE>>(this.attributesExtractors), this.errorCauseExtractor);
    }

    private static interface InstrumenterConstructor<RQ, RS> {
        public Instrumenter<RQ, RS> create(String var1, Tracer var2, SpanNameExtractor<? super RQ> var3, SpanKindExtractor<? super RQ> var4, SpanStatusExtractor<? super RQ, ? super RS> var5, List<? extends AttributesExtractor<? super RQ, ? super RS>> var6, ErrorCauseExtractor var7);

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> internal() {
            return Instrumenter::new;
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingToDownstream(ContextPropagators propagators, TextMapSetter<RQ> setter) {
            return (instrumentationName, tracer, spanName, spanKind, spanStatus, attributes, errorCauseExtractor) -> new ClientInstrumenter(instrumentationName, tracer, spanName, spanKind, spanStatus, attributes, errorCauseExtractor, propagators, setter);
        }

        public static <RQ, RS> InstrumenterConstructor<RQ, RS> propagatingFromUpstream(ContextPropagators propagators, TextMapGetter<RQ> getter) {
            return (instrumentationName, tracer, spanName, spanKind, spanStatus, attributes, errorCauseExtractor) -> new ServerInstrumenter(instrumentationName, tracer, spanName, spanKind, spanStatus, attributes, errorCauseExtractor, propagators, getter);
        }
    }
}

