/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.jdbc.datasource;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.instrumentation.jdbc.datasource.JdbcTelemetry;
import io.opentelemetry.instrumentation.jdbc.datasource.internal.Experimental;
import io.opentelemetry.instrumentation.jdbc.internal.DbRequest;
import io.opentelemetry.instrumentation.jdbc.internal.JdbcInstrumenterFactory;
import io.opentelemetry.instrumentation.jdbc.internal.dbinfo.DbInfo;
import javax.sql.DataSource;

public final class JdbcTelemetryBuilder {
    private final OpenTelemetry openTelemetry;
    private boolean dataSourceInstrumenterEnabled = true;
    private boolean statementInstrumenterEnabled = true;
    private boolean statementSanitizationEnabled = true;
    private boolean transactionInstrumenterEnabled = false;
    private boolean captureQueryParameters = false;
    private boolean sqlCommenterEnabled = false;

    JdbcTelemetryBuilder(OpenTelemetry openTelemetry) {
        this.openTelemetry = openTelemetry;
    }

    @CanIgnoreReturnValue
    public JdbcTelemetryBuilder setDataSourceInstrumenterEnabled(boolean enabled) {
        this.dataSourceInstrumenterEnabled = enabled;
        return this;
    }

    @CanIgnoreReturnValue
    public JdbcTelemetryBuilder setStatementInstrumenterEnabled(boolean enabled) {
        this.statementInstrumenterEnabled = enabled;
        return this;
    }

    @CanIgnoreReturnValue
    public JdbcTelemetryBuilder setStatementSanitizationEnabled(boolean enabled) {
        this.statementSanitizationEnabled = enabled;
        return this;
    }

    @CanIgnoreReturnValue
    public JdbcTelemetryBuilder setTransactionInstrumenterEnabled(boolean enabled) {
        this.transactionInstrumenterEnabled = enabled;
        return this;
    }

    @CanIgnoreReturnValue
    public JdbcTelemetryBuilder setCaptureQueryParameters(boolean enabled) {
        this.captureQueryParameters = enabled;
        return this;
    }

    public JdbcTelemetry build() {
        Instrumenter<DataSource, DbInfo> dataSourceInstrumenter = JdbcInstrumenterFactory.createDataSourceInstrumenter(this.openTelemetry, this.dataSourceInstrumenterEnabled);
        Instrumenter<DbRequest, Void> statementInstrumenter = JdbcInstrumenterFactory.createStatementInstrumenter(this.openTelemetry, this.statementInstrumenterEnabled, this.statementSanitizationEnabled, this.captureQueryParameters);
        Instrumenter<DbRequest, Void> transactionInstrumenter = JdbcInstrumenterFactory.createTransactionInstrumenter(this.openTelemetry, this.transactionInstrumenterEnabled);
        return new JdbcTelemetry(dataSourceInstrumenter, statementInstrumenter, transactionInstrumenter, this.captureQueryParameters, this.sqlCommenterEnabled);
    }

    static {
        Experimental.internalSetEnableSqlCommenter((builder, sqlCommenterEnabled) -> {
            builder.sqlCommenterEnabled = sqlCommenterEnabled;
        });
    }
}

