/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal;

import io.opentelemetry.instrumentation.api.incubator.semconv.messaging.MessagingAttributesGetter;
import io.opentelemetry.instrumentation.kafkaclients.common.v0_11.internal.KafkaProducerRequest;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.kafka.clients.producer.RecordMetadata;

enum KafkaProducerAttributesGetter implements MessagingAttributesGetter<KafkaProducerRequest, RecordMetadata>
{
    INSTANCE;


    public String getSystem(KafkaProducerRequest request) {
        return "kafka";
    }

    public String getDestination(KafkaProducerRequest request) {
        return request.getRecord().topic();
    }

    @Nullable
    public String getDestinationTemplate(KafkaProducerRequest request) {
        return null;
    }

    public boolean isTemporaryDestination(KafkaProducerRequest request) {
        return false;
    }

    public boolean isAnonymousDestination(KafkaProducerRequest request) {
        return false;
    }

    @Nullable
    public String getConversationId(KafkaProducerRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageBodySize(KafkaProducerRequest request) {
        return null;
    }

    @Nullable
    public Long getMessageEnvelopeSize(KafkaProducerRequest request) {
        return null;
    }

    @Nullable
    public String getMessageId(KafkaProducerRequest request, @Nullable RecordMetadata recordMetadata) {
        return null;
    }

    @Nullable
    public String getClientId(KafkaProducerRequest request) {
        return request.getClientId();
    }

    @Nullable
    public Long getBatchMessageCount(KafkaProducerRequest request, @Nullable RecordMetadata recordMetadata) {
        return null;
    }

    public List<String> getMessageHeader(KafkaProducerRequest request, String name) {
        return StreamSupport.stream(request.getRecord().headers().headers(name).spliterator(), false).filter(header -> header.value() != null).map(header -> new String(header.value(), StandardCharsets.UTF_8)).collect(Collectors.toList());
    }
}

