/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.log4j.appender.v2_17;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.ThreadContext;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.impl.ThrowableProxy;
import org.apache.logging.log4j.core.time.Instant;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.StringMapMessage;
import org.apache.logging.log4j.message.StructuredDataMessage;
import org.apache.logging.log4j.util.ReadOnlyStringMap;
import org.apache.logging.log4j.util.SortedArrayStringMap;

class LogEventToReplay
implements LogEvent {
    private static final long serialVersionUID = 1L;
    private final String loggerName;
    private final Message message;
    private final Level level;
    private final Instant instant;
    private final Throwable thrown;
    private final Marker marker;
    private final ReadOnlyStringMap contextData;
    private final String threadName;
    private final long threadId;
    private final StackTraceElement source;

    LogEventToReplay(LogEvent logEvent, boolean captureCodeAttributes) {
        this.loggerName = logEvent.getLoggerName();
        Message messageOrigin = logEvent.getMessage();
        if (messageOrigin instanceof StructuredDataMessage) {
            StructuredDataMessage structuredDataMessage = (StructuredDataMessage)messageOrigin;
            this.message = new StructuredDataMessage(structuredDataMessage.getId(), structuredDataMessage.getFormat(), structuredDataMessage.getType(), structuredDataMessage.getData());
        } else {
            this.message = messageOrigin instanceof StringMapMessage ? messageOrigin : new MessageCopy(logEvent.getMessage());
        }
        this.level = logEvent.getLevel();
        this.instant = logEvent.getInstant();
        this.thrown = logEvent.getThrown();
        this.marker = logEvent.getMarker();
        this.contextData = new SortedArrayStringMap(logEvent.getContextData());
        this.threadName = logEvent.getThreadName();
        this.threadId = logEvent.getThreadId();
        this.source = captureCodeAttributes ? logEvent.getSource() : null;
    }

    public LogEvent toImmutable() {
        return null;
    }

    public Map<String, String> getContextMap() {
        return Collections.emptyMap();
    }

    public ReadOnlyStringMap getContextData() {
        return this.contextData;
    }

    @Nullable
    public ThreadContext.ContextStack getContextStack() {
        return null;
    }

    public String getLoggerFqcn() {
        return null;
    }

    public Level getLevel() {
        return this.level;
    }

    public String getLoggerName() {
        return this.loggerName;
    }

    public Marker getMarker() {
        return this.marker;
    }

    public Message getMessage() {
        return this.message;
    }

    public long getTimeMillis() {
        return 0L;
    }

    public Instant getInstant() {
        return this.instant;
    }

    public StackTraceElement getSource() {
        return this.source;
    }

    public String getThreadName() {
        return this.threadName;
    }

    public long getThreadId() {
        return this.threadId;
    }

    public int getThreadPriority() {
        return 0;
    }

    public Throwable getThrown() {
        return this.thrown;
    }

    public ThrowableProxy getThrownProxy() {
        return null;
    }

    public boolean isEndOfBatch() {
        return false;
    }

    public boolean isIncludeLocation() {
        return false;
    }

    public void setEndOfBatch(boolean endOfBatch) {
    }

    public void setIncludeLocation(boolean locationRequired) {
    }

    public long getNanoTime() {
        return 0L;
    }

    private static class MessageCopy
    implements Message {
        private static final long serialVersionUID = 1L;
        private final String formattedMessage;
        private final String format;
        private final Object[] parameters;
        private final Throwable throwable;

        MessageCopy(Message message) {
            this.formattedMessage = message.getFormattedMessage();
            this.format = message.getFormat();
            this.parameters = message.getParameters();
            this.throwable = message.getThrowable();
        }

        public String getFormattedMessage() {
            return this.formattedMessage;
        }

        public String getFormat() {
            return this.format;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        public Throwable getThrowable() {
            return this.throwable;
        }
    }
}

