/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.resources.internal;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.instrumentation.resources.internal.MainJarPathFinder;
import io.opentelemetry.instrumentation.resources.internal.MainJarPathHolder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.semconv.ServiceAttributes;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class ManifestResourceExtractor {
    private static final Logger logger = Logger.getLogger(ManifestResourceExtractor.class.getName());
    private final Supplier<Optional<Path>> jarPathSupplier;
    private final Function<Path, Optional<Manifest>> manifestReader;

    public ManifestResourceExtractor() {
        this(MainJarPathHolder::getJarPath, ManifestResourceExtractor::readManifest);
    }

    ManifestResourceExtractor(MainJarPathFinder jarPathFinder, Function<Path, Optional<Manifest>> manifestReader) {
        this(() -> Optional.ofNullable(jarPathFinder.detectJarPath()), manifestReader);
    }

    private ManifestResourceExtractor(Supplier<Optional<Path>> jarPathSupplier, Function<Path, Optional<Manifest>> manifestReader) {
        this.jarPathSupplier = jarPathSupplier;
        this.manifestReader = manifestReader;
    }

    public Resource extract() {
        return this.jarPathSupplier.get().flatMap(this.manifestReader).map(manifest -> ManifestResourceExtractor.extract(manifest)).orElseGet(Resource::empty);
    }

    private static Resource extract(Manifest manifest) {
        String serviceVersion;
        String serviceName = manifest.getMainAttributes().getValue("Implementation-Title");
        AttributesBuilder builder = Attributes.builder();
        if (serviceName != null) {
            builder.put(ServiceAttributes.SERVICE_NAME, (Object)serviceName);
        }
        if ((serviceVersion = manifest.getMainAttributes().getValue("Implementation-Version")) != null) {
            builder.put(ServiceAttributes.SERVICE_VERSION, (Object)serviceVersion);
        }
        return Resource.create((Attributes)builder.build());
    }

    private static Optional<Manifest> readManifest(Path jarPath) {
        Optional<Manifest> optional;
        JarFile jarFile = new JarFile(jarPath.toFile(), false);
        try {
            optional = Optional.of(jarFile.getManifest());
        }
        catch (Throwable throwable) {
            try {
                try {
                    jarFile.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException exception) {
                logger.log(Level.FINE, "Error reading manifest", exception);
                return Optional.empty();
            }
        }
        jarFile.close();
        return optional;
    }
}

