/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java17.internal.garbagecollection;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.Constants;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.DurationUtil;
import io.opentelemetry.instrumentation.runtimemetrics.java17.internal.RecordedEventHandler;
import java.time.Duration;
import java.util.Optional;
import jdk.jfr.consumer.RecordedEvent;

public final class G1GarbageCollectionHandler
implements RecordedEventHandler {
    private static final String EVENT_NAME = "jdk.G1GarbageCollection";
    private static final Attributes ATTR = Attributes.of(Constants.ATTR_GC_NAME, (Object)"G1 Young Generation", Constants.ATTR_GC_ACTION, (Object)"end of minor GC");
    private final DoubleHistogram histogram;

    public G1GarbageCollectionHandler(Meter meter) {
        this.histogram = meter.histogramBuilder("jvm.gc.duration").setDescription("Duration of JVM garbage collection actions.").setUnit("s").build();
    }

    @Override
    public void accept(RecordedEvent ev) {
        this.histogram.record(DurationUtil.millisToSeconds(ev.getLong("duration")), ATTR);
    }

    @Override
    public String getEventName() {
        return EVENT_NAME;
    }

    @Override
    public JfrFeature getFeature() {
        return JfrFeature.GC_DURATION_METRICS;
    }

    @Override
    public Optional<Duration> getPollingDuration() {
        return Optional.of(Duration.ofSeconds(1L));
    }
}

