/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.bootstrap.internal;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.bootstrap.internal.InstrumentationConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public final class ConfiguredResourceAttributesHolder {
    private static final Map<String, String> resourceAttributes = new HashMap<String, String>();

    public static Map<String, String> getResourceAttributes() {
        return resourceAttributes;
    }

    public static void initialize(Attributes resourceAttribute) {
        List<String> mdcResourceAttributes = InstrumentationConfig.get().getList("otel.instrumentation.common.mdc.resource-attributes", Collections.emptyList());
        for (String key : mdcResourceAttributes) {
            String value = (String)resourceAttribute.get(AttributeKey.stringKey((String)key));
            if (value == null) continue;
            resourceAttributes.put(key, value);
        }
    }

    @Nullable
    public static String getAttributeValue(String key) {
        return resourceAttributes.get(key);
    }

    private ConfiguredResourceAttributesHolder() {
    }
}

