/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.auto.service.AutoService;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.exporter.logging.LoggingSpanExporter;
import io.opentelemetry.javaagent.tooling.AddThreadDetailsSpanProcessor;
import io.opentelemetry.javaagent.tooling.config.AgentConfig;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizer;
import io.opentelemetry.sdk.autoconfigure.spi.AutoConfigurationCustomizerProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.export.SimpleSpanProcessor;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.Collections;

@AutoService(value={AutoConfigurationCustomizerProvider.class})
public class AgentTracerProviderConfigurer
implements AutoConfigurationCustomizerProvider {
    private static final String ADD_THREAD_DETAILS = "otel.javaagent.add-thread-details";

    public void customize(AutoConfigurationCustomizer autoConfigurationCustomizer) {
        autoConfigurationCustomizer.addTracerProviderCustomizer(AgentTracerProviderConfigurer::configure);
    }

    @CanIgnoreReturnValue
    private static SdkTracerProviderBuilder configure(SdkTracerProviderBuilder sdkTracerProviderBuilder, ConfigProperties config) {
        if (!config.getBoolean("otel.javaagent.enabled", true)) {
            return sdkTracerProviderBuilder;
        }
        if (config.getBoolean(ADD_THREAD_DETAILS, true)) {
            sdkTracerProviderBuilder.addSpanProcessor((SpanProcessor)new AddThreadDetailsSpanProcessor());
        }
        AgentTracerProviderConfigurer.maybeEnableLoggingExporter(sdkTracerProviderBuilder, config);
        return sdkTracerProviderBuilder;
    }

    private static void maybeEnableLoggingExporter(SdkTracerProviderBuilder builder, ConfigProperties config) {
        if (AgentConfig.isDebugModeEnabled(config) && AgentTracerProviderConfigurer.loggingExporterIsNotAlreadyConfigured(config)) {
            builder.addSpanProcessor(SimpleSpanProcessor.create((SpanExporter)LoggingSpanExporter.create()));
        }
    }

    private static boolean loggingExporterIsNotAlreadyConfigured(ConfigProperties config) {
        return !config.getList("otel.traces.exporter", Collections.emptyList()).contains("logging");
    }
}

