/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.DefineClassHelper;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.objectweb.asm.ClassReader;

public class DefineClassHandler
implements DefineClassHelper.Handler {
    public static final DefineClassHandler INSTANCE = new DefineClassHandler();
    private static final ThreadLocal<DefineClassContextImpl> defineClassContext = ThreadLocal.withInitial(() -> DefineClassContextImpl.access$100());

    private DefineClassHandler() {
    }

    public DefineClassHelper.Handler.DefineClassContext beforeDefineClass(ClassLoader classLoader, String className, byte[] classBytes, int offset, int length) {
        if (classBytes == null || classBytes.length == 40 && new String(classBytes, StandardCharsets.ISO_8859_1).startsWith("J9ROMCLASSCOOKIE")) {
            return null;
        }
        HashSet<String> superNames = new HashSet<String>();
        DefineClassContextImpl context = DefineClassContextImpl.enter();
        try {
            String[] interfaces;
            ClassReader cr = new ClassReader(classBytes, offset, length);
            String superName = cr.getSuperName();
            if (superName != null) {
                String superDotName = superName.replace('/', '.');
                Class<?> clazz = Class.forName(superDotName, false, classLoader);
                DefineClassHandler.addSuperNames(superNames, clazz);
            }
            for (String interfaceName : interfaces = cr.getInterfaces()) {
                String interfaceDotName = interfaceName.replace('/', '.');
                Class<?> clazz = Class.forName(interfaceDotName, false, classLoader);
                DefineClassHandler.addSuperNames(superNames, clazz);
            }
            context.superDotNames = superNames;
        }
        catch (Throwable throwable) {
            context.failedClassDotName = className;
        }
        return context;
    }

    public DefineClassHelper.Handler.DefineClassContext beforeDefineLambdaClass(Class<?> lambdaInterface) {
        DefineClassContextImpl context = DefineClassContextImpl.enter();
        HashSet<String> superNames = new HashSet<String>();
        DefineClassHandler.addSuperNames(superNames, lambdaInterface);
        context.superDotNames = superNames;
        return context;
    }

    private static void addSuperNames(Set<String> superNames, Class<?> clazz) {
        if (clazz == null || !superNames.add(clazz.getName())) {
            return;
        }
        DefineClassHandler.addSuperNames(superNames, clazz.getSuperclass());
        for (Class<?> interfaceClass : clazz.getInterfaces()) {
            DefineClassHandler.addSuperNames(superNames, interfaceClass);
        }
    }

    public void afterDefineClass(DefineClassHelper.Handler.DefineClassContext context) {
        if (context != null) {
            context.exit();
        }
    }

    public static boolean isFailedClass(String dotClassName) {
        DefineClassContextImpl context = defineClassContext.get();
        return context.failedClassDotName != null && context.failedClassDotName.equals(dotClassName);
    }

    public static Set<String> getSuperTypes() {
        Set<String> superNames = DefineClassHandler.defineClassContext.get().superDotNames;
        return superNames == null ? Collections.emptySet() : superNames;
    }

    private static class DefineClassContextImpl
    implements DefineClassHelper.Handler.DefineClassContext {
        private static final DefineClassContextImpl NOP = new DefineClassContextImpl();
        private final DefineClassContextImpl previous;
        String failedClassDotName;
        Set<String> superDotNames;

        private DefineClassContextImpl() {
            this.previous = null;
        }

        private DefineClassContextImpl(DefineClassContextImpl previous) {
            this.previous = previous;
        }

        static DefineClassContextImpl enter() {
            DefineClassContextImpl previous = (DefineClassContextImpl)defineClassContext.get();
            DefineClassContextImpl context = new DefineClassContextImpl(previous);
            defineClassContext.set(context);
            return context;
        }

        public void exit() {
            defineClassContext.set(this.previous);
        }
    }
}

