/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import io.opentelemetry.javaagent.bootstrap.AgentClassLoader;
import io.opentelemetry.javaagent.bootstrap.AgentInitializer;
import io.opentelemetry.javaagent.tooling.AgentInstaller;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Utils {
    private static final AgentClassLoader.BootstrapClassLoaderProxy unitTestBootstrapProxy = new AgentClassLoader.BootstrapClassLoaderProxy(null);

    public static ClassLoader getAgentClassLoader() {
        return AgentInstaller.class.getClassLoader();
    }

    public static ClassLoader getExtensionsClassLoader() {
        return AgentInitializer.getExtensionsClassLoader();
    }

    public static AgentClassLoader.BootstrapClassLoaderProxy getBootstrapProxy() {
        if (Utils.getAgentClassLoader() instanceof AgentClassLoader) {
            return ((AgentClassLoader)Utils.getAgentClassLoader()).getBootstrapProxy();
        }
        return unitTestBootstrapProxy;
    }

    public static String getResourceName(String className) {
        return className.replace('.', '/') + ".class";
    }

    public static String getClassName(String internalName) {
        return internalName.replace('/', '.');
    }

    public static String getInternalName(Class<?> clazz) {
        return clazz.getName().replace('.', '/');
    }

    public static MethodDescription getMethodDefinition(TypeDefinition type, String methodName) {
        return (MethodDescription)((MethodList)type.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)methodName))).getOnly();
    }

    private Utils() {
    }
}

