/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.instrumentation.indy;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.ParameterDescription;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.InvokeDynamic;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.bytecode.StackManipulation;
import net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import net.bytebuddy.utility.JavaConstant;

public class IndyProxyFactory {
    private static final String DELEGATE_FIELD_NAME = "delegate";
    private final MethodDescription.InDefinedShape indyBootstrapMethod;
    private final BootstrapArgsProvider bootstrapArgsProvider;

    public IndyProxyFactory(Method bootstrapMethod, BootstrapArgsProvider bootstrapArgsProvider) {
        this.indyBootstrapMethod = new MethodDescription.ForLoadedMethod(bootstrapMethod);
        this.bootstrapArgsProvider = bootstrapArgsProvider;
    }

    public DynamicType.Unloaded<?> generateProxy(TypeDescription classToProxy, String proxyClassName) {
        TypeDescription.Generic superClass = classToProxy.getSuperClass();
        DynamicType.Builder<?> builder = new ByteBuddy().subclass((TypeDefinition)superClass, (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).implement((Collection)classToProxy.getInterfaces()).name(proxyClassName).annotateType((Collection)classToProxy.getDeclaredAnnotations()).defineField(DELEGATE_FIELD_NAME, Object.class, 18);
        for (MethodDescription.InDefinedShape method : classToProxy.getDeclaredMethods()) {
            List<? extends JavaConstant> bootstrapArgs;
            if (!method.isPublic()) continue;
            if (method.isConstructor()) {
                bootstrapArgs = this.bootstrapArgsProvider.getBootstrapArgsForMethod(classToProxy, method);
                builder = this.createProxyConstructor(superClass, method, bootstrapArgs, builder);
                continue;
            }
            if (!method.isMethod()) continue;
            bootstrapArgs = this.bootstrapArgsProvider.getBootstrapArgsForMethod(classToProxy, method);
            builder = this.createProxyMethod(method, bootstrapArgs, builder);
        }
        return builder.make();
    }

    private DynamicType.Builder<?> createProxyMethod(MethodDescription.InDefinedShape proxiedMethod, List<? extends JavaConstant> bootstrapArgs, DynamicType.Builder<?> builder) {
        InvokeDynamic.WithImplicitTarget body = InvokeDynamic.bootstrap((MethodDescription.InDefinedShape)this.indyBootstrapMethod, bootstrapArgs);
        if (!proxiedMethod.isStatic()) {
            body = body.withField(DELEGATE_FIELD_NAME);
        }
        body = body.withMethodArguments();
        int modifiers = 1 | (proxiedMethod.isStatic() ? 8 : 0);
        return IndyProxyFactory.createProxyMethodOrConstructor(proxiedMethod, builder.defineMethod(proxiedMethod.getName(), (TypeDefinition)proxiedMethod.getReturnType(), modifiers), (Implementation)body);
    }

    private DynamicType.Builder<?> createProxyConstructor(TypeDescription.Generic superClass, MethodDescription.InDefinedShape proxiedConstructor, List<? extends JavaConstant> bootstrapArgs, DynamicType.Builder<?> builder) {
        MethodDescription defaultSuperCtor = IndyProxyFactory.findDefaultConstructor(superClass);
        Implementation.Composable fieldAssignment = FieldAccessor.ofField((String)DELEGATE_FIELD_NAME).setsValue((StackManipulation)new StackManipulation.Compound(new StackManipulation[]{MethodVariableAccess.allArgumentsOf((MethodDescription)proxiedConstructor), MethodInvocation.invoke((MethodDescription.InDefinedShape)this.indyBootstrapMethod).dynamic("ctor", TypeDescription.ForLoadedType.of(Object.class), (List)proxiedConstructor.getParameters().asTypeList().asErasures(), bootstrapArgs)}), Object.class);
        Implementation.Composable ctorBody = MethodCall.invoke((MethodDescription)defaultSuperCtor).andThen(fieldAssignment);
        return IndyProxyFactory.createProxyMethodOrConstructor(proxiedConstructor, builder.defineConstructor(1), (Implementation)ctorBody);
    }

    private static MethodDescription findDefaultConstructor(TypeDescription.Generic superClass) {
        return (MethodDescription)superClass.getDeclaredMethods().stream().filter(MethodDescription::isConstructor).filter(constructor -> constructor.getParameters().isEmpty()).findFirst().orElseThrow(() -> new IllegalArgumentException("Superclass of provided type does not define a default constructor"));
    }

    private static DynamicType.Builder<?> createProxyMethodOrConstructor(MethodDescription.InDefinedShape method, DynamicType.Builder.MethodDefinition.ParameterDefinition<?> methodDef, Implementation methodBody) {
        for (ParameterDescription param : method.getParameters()) {
            methodDef = methodDef.withParameter((TypeDefinition)param.getType(), param.getName(), param.getModifiers()).annotateParameter((Collection)param.getDeclaredAnnotations());
        }
        return methodDef.throwing((Collection)method.getExceptionTypes()).intercept(methodBody).annotateMethod((Collection)method.getDeclaredAnnotations());
    }

    @FunctionalInterface
    public static interface BootstrapArgsProvider {
        public List<? extends JavaConstant> getBootstrapArgsForMethod(TypeDescription var1, MethodDescription.InDefinedShape var2);
    }
}

