/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.nio.charset.StandardCharsets;
import java.security.AccessController;
import java.security.Permission;

public class ByteArrayUrl {
    private static final String URL_SCHEMA = "x-otel-binary";

    private ByteArrayUrl() {
    }

    public static URL create(String contentName, byte[] data) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(() -> ByteArrayUrl.doCreate(contentName, data));
        }
        return ByteArrayUrl.doCreate(contentName, data);
    }

    private static URL doCreate(String contentName, byte[] data) {
        try {
            String file = URLEncoder.encode(contentName, StandardCharsets.UTF_8.toString());
            return new URL(URL_SCHEMA, null, -1, file, new ByteArrayUrlStreamHandler(data));
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Failed to generate URL for the provided arguments", e);
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    private static class ByteArrayUrlStreamHandler
    extends URLStreamHandler {
        private final byte[] binaryRepresentation;

        private ByteArrayUrlStreamHandler(byte[] binaryRepresentation) {
            this.binaryRepresentation = binaryRepresentation;
        }

        @Override
        protected URLConnection openConnection(URL url) {
            return new ByteArrayUrlConnection(url);
        }

        private class ByteArrayUrlConnection
        extends URLConnection {
            private final InputStream inputStream;

            protected ByteArrayUrlConnection(URL url) {
                super(url);
                this.inputStream = new ByteArrayInputStream(ByteArrayUrlStreamHandler.this.binaryRepresentation);
            }

            @Override
            public void connect() {
                this.connected = true;
            }

            @Override
            public InputStream getInputStream() {
                this.connect();
                return this.inputStream;
            }

            @Override
            public Permission getPermission() {
                return null;
            }

            @Override
            public long getContentLengthLong() {
                return ByteArrayUrlStreamHandler.this.binaryRepresentation.length;
            }
        }
    }
}

