/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.instrumentation.api.internal.cache.Cache;
import io.opentelemetry.javaagent.bootstrap.HelperResources;
import io.opentelemetry.javaagent.bootstrap.InjectedClassHelper;
import io.opentelemetry.javaagent.extension.instrumentation.internal.injection.InjectionMode;
import io.opentelemetry.javaagent.tooling.HelperClassDefinition;
import io.opentelemetry.javaagent.tooling.HelperInjectorListener;
import io.opentelemetry.javaagent.tooling.TransformSafeLogger;
import io.opentelemetry.javaagent.tooling.muzzle.HelperResource;
import java.io.File;
import java.io.IOException;
import java.lang.instrument.Instrumentation;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.bytebuddy.agent.builder.AgentBuilder;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.loading.ClassInjector;
import net.bytebuddy.utility.JavaModule;

public class HelperInjector
implements AgentBuilder.Transformer {
    private static final TransformSafeLogger logger = TransformSafeLogger.getLogger(HelperInjector.class);
    private static final ProtectionDomain PROTECTION_DOMAIN = HelperInjector.class.getProtectionDomain();
    private static volatile HelperInjectorListener helperInjectorListener;
    private static final ClassLoader BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
    private static final HelperClassInjector BOOT_CLASS_INJECTOR;
    private static final Cache<ClassLoader, Map<String, HelperClassInjector>> helperInjectors;
    private final String requestingName;
    private final Function<ClassLoader, List<HelperClassDefinition>> helperClassesGenerator;
    private final List<HelperResource> helperResources;
    @Nullable
    private final ClassLoader helpersSource;
    @Nullable
    private final Instrumentation instrumentation;
    private final Cache<ClassLoader, Boolean> injectedClassLoaders = Cache.weak();

    public HelperInjector(String requestingName, List<String> helperClassNames, List<HelperResource> helperResources, ClassLoader helpersSource, Instrumentation instrumentation) {
        this.requestingName = requestingName;
        List helpers = helperClassNames.stream().map(className -> HelperClassDefinition.create(className, helpersSource, InjectionMode.CLASS_ONLY)).collect(Collectors.toList());
        this.helperClassesGenerator = cl -> helpers;
        this.helperResources = helperResources;
        this.helpersSource = helpersSource;
        this.instrumentation = instrumentation;
    }

    public HelperInjector(String requestingName, Function<ClassLoader, List<HelperClassDefinition>> helperClassesGenerators, List<HelperResource> helperResources, ClassLoader helpersSource, Instrumentation instrumentation) {
        this.requestingName = requestingName;
        this.helperClassesGenerator = helperClassesGenerators;
        this.helperResources = helperResources;
        this.helpersSource = helpersSource;
        this.instrumentation = instrumentation;
    }

    public static HelperInjector forDynamicTypes(String requestingName, Collection<DynamicType.Unloaded<?>> helpers, Instrumentation instrumentation) {
        List helperDefinitions = helpers.stream().map(helperType -> HelperClassDefinition.create(helperType, InjectionMode.CLASS_ONLY)).collect(Collectors.toList());
        return new HelperInjector(requestingName, cl -> helperDefinitions, Collections.emptyList(), null, instrumentation);
    }

    public static void setHelperInjectorListener(HelperInjectorListener listener) {
        helperInjectorListener = listener;
    }

    @CanIgnoreReturnValue
    public DynamicType.Builder<?> transform(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassLoader classLoader, JavaModule javaModule, ProtectionDomain protectionDomain) {
        this.injectedClassLoaders.computeIfAbsent((Object)HelperInjector.maskNullClassLoader(classLoader), cl -> {
            List<HelperClassDefinition> helpers = this.helperClassesGenerator.apply((ClassLoader)cl);
            LinkedHashMap classesToInject = helpers.stream().filter(helper -> helper.getInjectionMode().shouldInjectClass()).collect(Collectors.toMap(HelperClassDefinition::getClassName, helper -> () -> helper.getBytecode().getBytecode(), (a, b) -> {
                throw new IllegalStateException("Duplicate classnames for helper class detected!");
            }, LinkedHashMap::new));
            Map<String, URL> classResourcesToInject = helpers.stream().filter(helper -> helper.getInjectionMode().shouldInjectResource()).collect(Collectors.toMap(helper -> helper.getClassName().replace('.', '/') + ".class", helper -> helper.getBytecode().getUrl()));
            this.injectHelperClasses(typeDescription, (ClassLoader)cl, classesToInject);
            if (!HelperInjector.isBootClassLoader(cl)) {
                this.injectHelperResources((ClassLoader)cl, classResourcesToInject);
            }
            return true;
        });
        return builder;
    }

    private void injectHelperResources(ClassLoader classLoader, Map<String, URL> additionalResources) {
        for (HelperResource helperResource : this.helperResources) {
            ArrayList<URL> resources;
            try {
                resources = Collections.list(this.helpersSource.getResources(helperResource.getAgentPath()));
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, "Unexpected exception occurred when loading resources {}; skipping", new Object[]{helperResource.getAgentPath()}, e);
                continue;
            }
            if (resources.isEmpty()) {
                logger.log(Level.FINE, "Helper resources {0} requested but not found.", helperResource.getAgentPath());
                continue;
            }
            if (helperResource.allClassLoaders()) {
                logger.log(Level.FINE, "Injecting resources onto all classloaders: {0}", helperResource.getApplicationPath());
                HelperResources.registerForAllClassLoaders((String)helperResource.getApplicationPath(), resources);
                continue;
            }
            HelperInjector.injectResourceToClassloader(classLoader, helperResource.getApplicationPath(), resources);
        }
        additionalResources.forEach((path, url) -> HelperInjector.injectResourceToClassloader(classLoader, path, Collections.singletonList(url)));
    }

    private static void injectResourceToClassloader(ClassLoader classLoader, String path, List<URL> resources) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "Injecting resources onto class loader {0} -> {1}", new Object[]{classLoader, path});
        }
        HelperResources.register((ClassLoader)classLoader, (String)path, resources);
    }

    private void injectHelperClasses(TypeDescription typeDescription, ClassLoader classLoader, LinkedHashMap<String, Supplier<byte[]>> classnameToBytes) {
        if (classnameToBytes.isEmpty()) {
            return;
        }
        if (classLoader == BOOTSTRAP_CLASSLOADER_PLACEHOLDER && this.instrumentation == null) {
            logger.log(Level.SEVERE, "Cannot inject helpers into the bootstrap class loader without an instance of Instrumentation. Programmer error!");
            return;
        }
        try {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Injecting classes onto class loader {0} -> {1}", new Object[]{classLoader, classnameToBytes.keySet()});
            }
            Map map = (Map)helperInjectors.computeIfAbsent((Object)classLoader, unused -> new ConcurrentHashMap());
            for (Map.Entry<String, Supplier<byte[]>> entry : classnameToBytes.entrySet()) {
                HelperClassInjector injector = HelperInjector.isBootClassLoader(classLoader) ? BOOT_CLASS_INJECTOR : new HelperClassInjector(entry.getValue());
                map.put(entry.getKey(), injector);
            }
            if (HelperInjector.isBootClassLoader(classLoader)) {
                this.injectBootstrapClassLoader(classnameToBytes);
            }
        }
        catch (Exception e) {
            if (logger.isLoggable(Level.SEVERE)) {
                logger.log(Level.SEVERE, "Error preparing helpers while processing {0} for {1}. Failed to inject helper classes into instance {2}", new Object[]{typeDescription, this.requestingName, classLoader}, e);
            }
            throw new IllegalStateException(e);
        }
    }

    private static Map<String, byte[]> resolve(Map<String, Supplier<byte[]>> classes) {
        LinkedHashMap<String, byte[]> result = new LinkedHashMap<String, byte[]>();
        for (Map.Entry<String, Supplier<byte[]>> entry : classes.entrySet()) {
            result.put(entry.getKey(), entry.getValue().get());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Class<?>> injectBootstrapClassLoader(Map<String, Supplier<byte[]>> inject) throws IOException {
        Map<String, byte[]> classnameToBytes = HelperInjector.resolve(inject);
        if (helperInjectorListener != null) {
            helperInjectorListener.onInjection(classnameToBytes);
        }
        if (ClassInjector.UsingUnsafe.isAvailable()) {
            return ClassInjector.UsingUnsafe.ofBootLoader().injectRaw(classnameToBytes);
        }
        File tempDir = HelperInjector.createTempDir();
        try {
            Map map = ClassInjector.UsingInstrumentation.of((File)tempDir, (ClassInjector.UsingInstrumentation.Target)ClassInjector.UsingInstrumentation.Target.BOOTSTRAP, (Instrumentation)this.instrumentation).injectRaw(classnameToBytes);
            return map;
        }
        finally {
            HelperInjector.deleteTempDir(tempDir);
        }
    }

    private static File createTempDir() throws IOException {
        return Files.createTempDirectory("opentelemetry-temp-jars", new FileAttribute[0]).toFile();
    }

    private static void deleteTempDir(File file) {
        boolean deleted = file.delete();
        if (!deleted) {
            file.deleteOnExit();
        }
    }

    private static ClassLoader maskNullClassLoader(ClassLoader classLoader) {
        return classLoader != null ? classLoader : BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
    }

    private static boolean isBootClassLoader(ClassLoader classLoader) {
        return classLoader == BOOTSTRAP_CLASSLOADER_PLACEHOLDER;
    }

    public static boolean isInjectedClass(Class<?> clazz) {
        return HelperInjector.isInjectedClass(clazz.getClassLoader(), clazz.getName());
    }

    public static boolean isInjectedClass(ClassLoader classLoader, String className) {
        Map injectorMap = (Map)helperInjectors.get((Object)HelperInjector.maskNullClassLoader(classLoader));
        if (injectorMap == null) {
            return false;
        }
        return injectorMap.containsKey(className);
    }

    public static Class<?> loadHelperClass(ClassLoader classLoader, String className) {
        if (classLoader == null) {
            throw new IllegalStateException("boot loader not supported");
        }
        Map injectorMap = (Map)helperInjectors.get((Object)classLoader);
        if (injectorMap == null) {
            return null;
        }
        HelperClassInjector helperClassInjector = (HelperClassInjector)injectorMap.get(className);
        if (helperClassInjector == null) {
            return null;
        }
        return helperClassInjector.inject(classLoader, className);
    }

    private static <T> T execute(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    static {
        InjectedClassHelper.internalSetHelperClassDetector(HelperInjector::isInjectedClass);
        InjectedClassHelper.internalSetHelperClassLoader(HelperInjector::loadHelperClass);
        BOOTSTRAP_CLASSLOADER_PLACEHOLDER = new SecureClassLoader(null){

            public String toString() {
                return "<bootstrap>";
            }
        };
        BOOT_CLASS_INJECTOR = new HelperClassInjector(null){

            @Override
            Class<?> inject(ClassLoader classLoader, String className) {
                throw new UnsupportedOperationException("should not be called");
            }
        };
        helperInjectors = Cache.weak();
    }

    private static class HelperClassInjector {
        private final Supplier<byte[]> bytes;

        HelperClassInjector(Supplier<byte[]> bytes) {
            this.bytes = bytes;
        }

        Class<?> inject(ClassLoader classLoader, String className) {
            Map result = (Map)HelperInjector.execute(() -> new ClassInjector.UsingReflection(classLoader, PROTECTION_DOMAIN).injectRaw(Collections.singletonMap(className, this.bytes.get())));
            return (Class)result.get(className);
        }
    }
}

