/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.generation;

import io.opentelemetry.javaagent.extension.instrumentation.InstrumentationModule;
import io.opentelemetry.javaagent.tooling.muzzle.generation.MuzzleCodeGenerator;
import java.net.URLClassLoader;
import net.bytebuddy.asm.AsmVisitorWrapper;
import net.bytebuddy.build.Plugin;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.ClassFileLocator;
import net.bytebuddy.dynamic.DynamicType;

public final class MuzzleCodeGenerationPlugin
implements Plugin {
    private static final TypeDescription instrumentationModuleType = new TypeDescription.ForLoadedType(InstrumentationModule.class);
    private final URLClassLoader classLoader;

    public MuzzleCodeGenerationPlugin(URLClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public boolean matches(TypeDescription target) {
        if (target.isAbstract()) {
            return false;
        }
        boolean isInstrumentationModule = false;
        for (TypeDescription.Generic instrumentation = target.getSuperClass(); instrumentation != null; instrumentation = instrumentation.getSuperClass()) {
            if (!instrumentation.equals(instrumentationModuleType)) continue;
            isInstrumentationModule = true;
            break;
        }
        return isInstrumentationModule;
    }

    public DynamicType.Builder<?> apply(DynamicType.Builder<?> builder, TypeDescription typeDescription, ClassFileLocator classFileLocator) {
        return builder.visit((AsmVisitorWrapper)new MuzzleCodeGenerator(this.classLoader));
    }

    public void close() {
    }
}

