/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.tooling.muzzle.references;

public interface Flag {
    public boolean matches(int var1);

    public String name();

    public static enum OwnershipFlag implements Flag
    {
        STATIC{

            @Override
            public boolean matches(int asmFlags) {
                return (8 & asmFlags) != 0;
            }
        }
        ,
        NON_STATIC{

            @Override
            public boolean matches(int asmFlags) {
                return !STATIC.matches(asmFlags);
            }
        };

    }

    public static enum ManifestationFlag implements Flag
    {
        FINAL{

            @Override
            public boolean matches(int asmFlags) {
                return (0x10 & asmFlags) != 0;
            }
        }
        ,
        NON_FINAL{

            @Override
            public boolean matches(int asmFlags) {
                return !ABSTRACT.matches(asmFlags) && !FINAL.matches(asmFlags);
            }
        }
        ,
        ABSTRACT{

            @Override
            public boolean matches(int asmFlags) {
                return (0x400 & asmFlags) != 0;
            }
        }
        ,
        INTERFACE{

            @Override
            public boolean matches(int asmFlags) {
                return (0x200 & asmFlags) != 0;
            }
        }
        ,
        NON_INTERFACE{

            @Override
            public boolean matches(int asmFlags) {
                return !INTERFACE.matches(asmFlags);
            }
        };

    }

    public static enum MinimumVisibilityFlag implements Flag
    {
        PUBLIC{

            @Override
            public boolean matches(int asmFlags) {
                return VisibilityFlag.PUBLIC.matches(asmFlags);
            }
        }
        ,
        PROTECTED_OR_HIGHER{

            @Override
            public boolean matches(int asmFlags) {
                return VisibilityFlag.PUBLIC.matches(asmFlags) || VisibilityFlag.PROTECTED.matches(asmFlags);
            }
        }
        ,
        PACKAGE_OR_HIGHER{

            @Override
            public boolean matches(int asmFlags) {
                return !VisibilityFlag.PRIVATE.matches(asmFlags);
            }
        }
        ,
        PRIVATE_OR_HIGHER{

            @Override
            public boolean matches(int asmFlags) {
                return true;
            }
        };

    }

    public static enum VisibilityFlag implements Flag
    {
        PUBLIC{

            @Override
            public boolean matches(int asmFlags) {
                return (1 & asmFlags) != 0;
            }
        }
        ,
        PROTECTED{

            @Override
            public boolean matches(int asmFlags) {
                return (4 & asmFlags) != 0;
            }
        }
        ,
        PACKAGE{

            @Override
            public boolean matches(int asmFlags) {
                return !PUBLIC.matches(asmFlags) && !PROTECTED.matches(asmFlags) && !PRIVATE.matches(asmFlags);
            }
        }
        ,
        PRIVATE{

            @Override
            public boolean matches(int asmFlags) {
                return (2 & asmFlags) != 0;
            }
        };

    }
}

