/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry;

import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.context.propagation.DefaultContextPropagators;
import io.opentelemetry.context.propagation.HttpTextFormat;
import io.opentelemetry.correlationcontext.CorrelationContextManager;
import io.opentelemetry.correlationcontext.DefaultCorrelationContextManagerProvider;
import io.opentelemetry.correlationcontext.spi.CorrelationContextManagerProvider;
import io.opentelemetry.internal.Obfuscated;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.metrics.DefaultMetricsProvider;
import io.opentelemetry.metrics.MeterProvider;
import io.opentelemetry.metrics.spi.MetricsProvider;
import io.opentelemetry.trace.DefaultTraceProvider;
import io.opentelemetry.trace.Tracer;
import io.opentelemetry.trace.TracerProvider;
import io.opentelemetry.trace.propagation.HttpTraceContext;
import io.opentelemetry.trace.spi.TraceProvider;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class OpenTelemetry {
    private static final Object mutex = new Object();
    @Nullable
    private static volatile OpenTelemetry instance;
    private final TracerProvider tracerProvider;
    private final MeterProvider meterProvider;
    private final CorrelationContextManager contextManager;
    private volatile ContextPropagators propagators = DefaultContextPropagators.builder().addHttpTextFormat((HttpTextFormat)new HttpTraceContext()).build();

    public static TracerProvider getTracerProvider() {
        return OpenTelemetry.getInstance().tracerProvider;
    }

    public static MeterProvider getMeterProvider() {
        return OpenTelemetry.getInstance().meterProvider;
    }

    public static CorrelationContextManager getCorrelationContextManager() {
        return OpenTelemetry.getInstance().contextManager;
    }

    public static ContextPropagators getPropagators() {
        return OpenTelemetry.getInstance().propagators;
    }

    public static void setPropagators(ContextPropagators propagators) {
        Utils.checkNotNull(propagators, "propagators");
        OpenTelemetry.getInstance().propagators = propagators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static OpenTelemetry getInstance() {
        if (instance == null) {
            Object object = mutex;
            synchronized (object) {
                if (instance == null) {
                    instance = new OpenTelemetry();
                }
            }
        }
        return instance;
    }

    private OpenTelemetry() {
        TraceProvider traceProvider = OpenTelemetry.loadSpi(TraceProvider.class);
        this.tracerProvider = traceProvider != null ? new ObfuscatedTracerProvider(traceProvider.create()) : DefaultTraceProvider.getInstance().create();
        MetricsProvider metricsProvider = OpenTelemetry.loadSpi(MetricsProvider.class);
        this.meterProvider = metricsProvider != null ? metricsProvider.create() : DefaultMetricsProvider.getInstance().create();
        CorrelationContextManagerProvider contextManagerProvider = OpenTelemetry.loadSpi(CorrelationContextManagerProvider.class);
        this.contextManager = contextManagerProvider != null ? contextManagerProvider.create() : DefaultCorrelationContextManagerProvider.getInstance().create();
    }

    @Nullable
    private static <T> T loadSpi(Class<T> providerClass) {
        String specifiedProvider = System.getProperty(providerClass.getName());
        ServiceLoader<T> providers = ServiceLoader.load(providerClass);
        for (T provider : providers) {
            if (specifiedProvider != null && !specifiedProvider.equals(provider.getClass().getName())) continue;
            return provider;
        }
        if (specifiedProvider != null) {
            throw new IllegalStateException(String.format("Service provider %s not found", specifiedProvider));
        }
        return null;
    }

    static void reset() {
        instance = null;
    }

    @ThreadSafe
    private static class ObfuscatedTracerProvider
    implements TracerProvider,
    Obfuscated<TracerProvider> {
        private final TracerProvider delegate;

        private ObfuscatedTracerProvider(TracerProvider delegate) {
            this.delegate = delegate;
        }

        @Override
        public Tracer get(String instrumentationName) {
            return this.delegate.get(instrumentationName);
        }

        @Override
        public Tracer get(String instrumentationName, String instrumentationVersion) {
            return this.delegate.get(instrumentationName, instrumentationVersion);
        }

        @Override
        public TracerProvider unobfuscate() {
            return this.delegate;
        }
    }
}

