/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.trace;

import io.grpc.Context;
import io.opentelemetry.context.ContextUtils;
import io.opentelemetry.context.Scope;
import io.opentelemetry.trace.DefaultSpan;
import io.opentelemetry.trace.Span;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class TracingContextUtils {
    private static final Context.Key<Span> CONTEXT_SPAN_KEY = Context.key((String)"opentelemetry-trace-span-key");

    public static Context withSpan(Span span, Context context) {
        return context.withValue(CONTEXT_SPAN_KEY, (Object)span);
    }

    public static Span getCurrentSpan() {
        return TracingContextUtils.getSpan(Context.current());
    }

    public static Span getSpan(Context context) {
        Span span = (Span)CONTEXT_SPAN_KEY.get(context);
        return span == null ? DefaultSpan.getInvalid() : span;
    }

    @Nullable
    public static Span getSpanWithoutDefault(Context context) {
        return (Span)CONTEXT_SPAN_KEY.get(context);
    }

    public static Scope currentContextWith(Span span) {
        return ContextUtils.withScopedContext((Context)TracingContextUtils.withSpan(span, Context.current()));
    }

    private TracingContextUtils() {
    }
}

