/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.jaeger.thrift;

import io.jaegertracing.internal.exceptions.SenderException;
import io.jaegertracing.thrift.internal.senders.ThriftSender;
import io.jaegertracing.thriftjava.Process;
import io.jaegertracing.thriftjava.Tag;
import io.jaegertracing.thriftjava.TagType;
import io.opentelemetry.exporter.jaeger.thrift.Adapter;
import io.opentelemetry.exporter.jaeger.thrift.JaegerThriftSpanExporterBuilder;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import io.opentelemetry.semconv.resource.attributes.ResourceAttributes;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class JaegerThriftSpanExporter
implements SpanExporter {
    static final String DEFAULT_ENDPOINT = "http://localhost:14268/api/traces";
    private static final String DEFAULT_HOST_NAME = "unknown";
    private static final String CLIENT_VERSION_KEY = "jaeger.version";
    private static final String CLIENT_VERSION_VALUE = "opentelemetry-java";
    private static final String HOSTNAME_KEY = "hostname";
    private static final String IP_KEY = "ip";
    private static final String IP_DEFAULT = "0.0.0.0";
    private final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(JaegerThriftSpanExporter.class.getName()));
    private final AtomicBoolean isShutdown = new AtomicBoolean();
    private final ThriftSender thriftSender;
    private final Process process;

    JaegerThriftSpanExporter(ThriftSender thriftSender) {
        String ipv4;
        String hostname;
        this.thriftSender = thriftSender;
        try {
            hostname = InetAddress.getLocalHost().getHostName();
            ipv4 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            hostname = DEFAULT_HOST_NAME;
            ipv4 = IP_DEFAULT;
        }
        Tag clientTag = new Tag(CLIENT_VERSION_KEY, TagType.STRING).setVStr(CLIENT_VERSION_VALUE);
        Tag ipv4Tag = new Tag(IP_KEY, TagType.STRING).setVStr(ipv4);
        Tag hostnameTag = new Tag(HOSTNAME_KEY, TagType.STRING).setVStr(hostname);
        this.process = new Process();
        this.process.addToTags(clientTag);
        this.process.addToTags(ipv4Tag);
        this.process.addToTags(hostnameTag);
    }

    public CompletableResultCode export(Collection<SpanData> spans) {
        if (this.isShutdown.get()) {
            return CompletableResultCode.ofFailure();
        }
        Map<Process, List> batches = spans.stream().collect(Collectors.groupingBy(SpanData::getResource)).entrySet().stream().collect(Collectors.toMap(entry -> this.createProcess((Resource)entry.getKey()), entry -> Adapter.toJaeger((Collection)entry.getValue())));
        ArrayList batchResults = new ArrayList(batches.size());
        batches.forEach((process, jaegerSpans) -> {
            CompletableResultCode batchResult = new CompletableResultCode();
            batchResults.add(batchResult);
            try {
                this.thriftSender.send(process, jaegerSpans);
                batchResult.succeed();
            }
            catch (SenderException e) {
                this.logger.log(Level.WARNING, "Failed to export spans", (Throwable)e);
                batchResult.fail();
            }
        });
        return CompletableResultCode.ofAll(batchResults);
    }

    private Process createProcess(Resource resource) {
        Process result = new Process(this.process);
        String serviceName = (String)resource.getAttribute(ResourceAttributes.SERVICE_NAME);
        if (serviceName == null || serviceName.isEmpty()) {
            serviceName = (String)Resource.getDefault().getAttribute(ResourceAttributes.SERVICE_NAME);
        }
        if (serviceName != null) {
            result.setServiceName(serviceName);
        }
        List<Tag> tags = Adapter.toTags(resource.getAttributes());
        tags.forEach(arg_0 -> ((Process)result).addToTags(arg_0));
        return result;
    }

    public CompletableResultCode flush() {
        return CompletableResultCode.ofSuccess();
    }

    public static JaegerThriftSpanExporterBuilder builder() {
        return new JaegerThriftSpanExporterBuilder();
    }

    public CompletableResultCode shutdown() {
        if (!this.isShutdown.compareAndSet(false, true)) {
            this.logger.log(Level.INFO, "Calling shutdown() multiple times.");
        }
        return CompletableResultCode.ofSuccess();
    }
}

