/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.internal.otlp;

import io.opentelemetry.api.common.Value;
import io.opentelemetry.api.incubator.common.ExtendedAttributeKey;
import io.opentelemetry.api.incubator.common.ExtendedAttributes;
import io.opentelemetry.api.incubator.internal.InternalExtendedAttributeKeyImpl;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.internal.marshal.MarshalerContext;
import io.opentelemetry.exporter.internal.marshal.Serializer;
import io.opentelemetry.exporter.internal.otlp.AnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.ArrayAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.BoolAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.DoubleAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.ExtendedAttributeKeyValueStatelessMarshaler;
import io.opentelemetry.exporter.internal.otlp.IntAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.KeyValueListAnyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.KeyValueMarshaler;
import io.opentelemetry.exporter.internal.otlp.StringAnyValueMarshaler;
import io.opentelemetry.proto.logs.v1.internal.LogRecord;
import io.opentelemetry.sdk.logs.data.LogRecordData;
import io.opentelemetry.sdk.logs.data.internal.ExtendedLogRecordData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.function.BiConsumer;

public class IncubatingUtil {
    private static final boolean INCUBATOR_AVAILABLE;
    private static final byte[] EMPTY_BYTES;
    private static final KeyValueMarshaler[] EMPTY_REPEATED;

    private IncubatingUtil() {
    }

    public static boolean isExtendedLogRecordData(LogRecordData logRecordData) {
        return INCUBATOR_AVAILABLE && logRecordData instanceof ExtendedLogRecordData;
    }

    public static KeyValueMarshaler[] createdExtendedAttributesMarhsalers(LogRecordData logRecordData) {
        return IncubatingUtil.createForExtendedAttributes(IncubatingUtil.getExtendedAttributes(logRecordData));
    }

    public static int extendedAttributesSize(LogRecordData logRecordData) {
        return IncubatingUtil.getExtendedAttributes(logRecordData).size();
    }

    private static KeyValueMarshaler[] createForExtendedAttributes(ExtendedAttributes attributes) {
        if (attributes.isEmpty()) {
            return EMPTY_REPEATED;
        }
        final KeyValueMarshaler[] marshalers = new KeyValueMarshaler[attributes.size()];
        attributes.forEach(new BiConsumer<ExtendedAttributeKey<?>, Object>(){
            int index = 0;

            @Override
            public void accept(ExtendedAttributeKey<?> attributeKey, Object o) {
                marshalers[this.index++] = IncubatingUtil.create(attributeKey, o);
            }
        });
        return marshalers;
    }

    private static KeyValueMarshaler create(ExtendedAttributeKey<?> attributeKey, Object value) {
        byte[] keyUtf8 = attributeKey.getKey().isEmpty() ? EMPTY_BYTES : (attributeKey instanceof InternalExtendedAttributeKeyImpl ? ((InternalExtendedAttributeKeyImpl)attributeKey).getKeyUtf8() : attributeKey.getKey().getBytes(StandardCharsets.UTF_8));
        switch (attributeKey.getType()) {
            case STRING: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)StringAnyValueMarshaler.create((String)value));
            }
            case LONG: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)IntAnyValueMarshaler.create((Long)value));
            }
            case BOOLEAN: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)BoolAnyValueMarshaler.create((Boolean)value));
            }
            case DOUBLE: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)DoubleAnyValueMarshaler.create((Double)value));
            }
            case STRING_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)ArrayAnyValueMarshaler.createString((List)value));
            }
            case LONG_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)ArrayAnyValueMarshaler.createInt((List)value));
            }
            case BOOLEAN_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)ArrayAnyValueMarshaler.createBool((List)value));
            }
            case DOUBLE_ARRAY: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)ArrayAnyValueMarshaler.createDouble((List)value));
            }
            case EXTENDED_ATTRIBUTES: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)new KeyValueListAnyValueMarshaler(new KeyValueListAnyValueMarshaler.KeyValueListMarshaler(IncubatingUtil.createForExtendedAttributes((ExtendedAttributes)value))));
            }
            case VALUE: {
                return new KeyValueMarshaler(keyUtf8, (Marshaler)AnyValueMarshaler.create((Value)value));
            }
        }
        throw new IllegalArgumentException("Unsupported attribute type.");
    }

    public static int sizeExtendedAttributes(LogRecordData log, MarshalerContext context) {
        return ExtendedAttributeKeyValueStatelessMarshaler.sizeExtendedAttributes(LogRecord.ATTRIBUTES, IncubatingUtil.getExtendedAttributes(log), context);
    }

    public static void serializeExtendedAttributes(Serializer output, LogRecordData log, MarshalerContext context) throws IOException {
        ExtendedAttributeKeyValueStatelessMarshaler.serializeExtendedAttributes(output, LogRecord.ATTRIBUTES, IncubatingUtil.getExtendedAttributes(log), context);
    }

    private static ExtendedAttributes getExtendedAttributes(LogRecordData logRecordData) {
        if (!(logRecordData instanceof ExtendedLogRecordData)) {
            throw new IllegalArgumentException("logRecordData must be ExtendedLogRecordData");
        }
        return ((ExtendedLogRecordData)logRecordData).getExtendedAttributes();
    }

    static {
        boolean incubatorAvailable = false;
        try {
            Class.forName("io.opentelemetry.api.incubator.common.ExtendedAttributes");
            incubatorAvailable = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        INCUBATOR_AVAILABLE = incubatorAvailable;
        EMPTY_BYTES = new byte[0];
        EMPTY_REPEATED = new KeyValueMarshaler[0];
    }
}

