/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.trace.propagation;

import io.opentelemetry.api.trace.Span;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.context.Context;
import io.opentelemetry.context.propagation.TextMapSetter;
import io.opentelemetry.extension.trace.propagation.B3Propagator;
import io.opentelemetry.extension.trace.propagation.B3PropagatorInjector;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
final class B3PropagatorInjectorMultipleHeaders
implements B3PropagatorInjector {
    private static final Collection<String> FIELDS = Collections.unmodifiableList(Arrays.asList("X-B3-TraceId", "X-B3-SpanId", "X-B3-Sampled"));

    B3PropagatorInjectorMultipleHeaders() {
    }

    @Override
    public <C> void inject(Context context, @Nullable C carrier, TextMapSetter<C> setter) {
        String sampled;
        if (context == null) {
            return;
        }
        if (setter == null) {
            return;
        }
        SpanContext spanContext = Span.fromContext((Context)context).getSpanContext();
        if (!spanContext.isValid()) {
            return;
        }
        String string = sampled = spanContext.isSampled() ? "1" : "0";
        if (Boolean.TRUE.equals(context.get(B3Propagator.DEBUG_CONTEXT_KEY))) {
            setter.set(carrier, "X-B3-Flags", "1");
            sampled = "1";
        }
        setter.set(carrier, "X-B3-TraceId", spanContext.getTraceId());
        setter.set(carrier, "X-B3-SpanId", spanContext.getSpanId());
        setter.set(carrier, "X-B3-Sampled", sampled);
    }

    @Override
    public Collection<String> fields() {
        return FIELDS;
    }

    public String toString() {
        return "B3PropagatorInjectorMultipleHeaders";
    }
}

