/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import io.opentelemetry.sdk.common.Clock;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class TestClock
implements Clock {
    @GuardedBy(value="this")
    private long currentEpochNanos;

    private TestClock(long epochNanos) {
        this.currentEpochNanos = epochNanos;
    }

    public static TestClock create() {
        return TestClock.create(TimeUnit.MILLISECONDS.toNanos(1557212400000L));
    }

    public static TestClock create(long epochNanos) {
        return new TestClock(epochNanos);
    }

    public synchronized void setTime(long epochNanos) {
        this.currentEpochNanos = epochNanos;
    }

    public synchronized void advanceMillis(long millis) {
        long nanos = TimeUnit.MILLISECONDS.toNanos(millis);
        this.currentEpochNanos += nanos;
    }

    public synchronized void advanceNanos(long nanos) {
        this.currentEpochNanos += nanos;
    }

    @Override
    public synchronized long now() {
        return this.currentEpochNanos;
    }

    @Override
    public synchronized long nanoTime() {
        return this.currentEpochNanos;
    }
}

