/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.resources;

import com.google.auto.value.AutoValue;
import com.google.auto.value.extension.memoized.Memoized;
import io.opentelemetry.common.AttributeConsumer;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import io.opentelemetry.internal.StringUtils;
import io.opentelemetry.internal.Utils;
import io.opentelemetry.sdk.resources.AutoValue_Resource;
import io.opentelemetry.sdk.resources.EnvAutodetectResource;
import io.opentelemetry.sdk.resources.ResourceProvider;
import io.opentelemetry.sdk.resources.ResourcesConfig;
import java.util.Objects;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
@AutoValue
public abstract class Resource {
    private static final int MAX_LENGTH = 255;
    private static final String ERROR_MESSAGE_INVALID_CHARS = " should be a ASCII string with a length greater than 0 and not exceed 255 characters.";
    private static final String ERROR_MESSAGE_INVALID_VALUE = " should be a ASCII string with a length not exceed 255 characters.";
    private static final Resource EMPTY = Resource.create(Attributes.empty());
    private static final AttributeKey<String> SDK_NAME = AttributeKey.stringKey((String)"telemetry.sdk.name");
    private static final AttributeKey<String> SDK_LANGUAGE = AttributeKey.stringKey((String)"telemetry.sdk.language");
    private static final AttributeKey<String> SDK_VERSION = AttributeKey.stringKey((String)"telemetry.sdk.version");
    private static final Resource TELEMETRY_SDK = Resource.create(Attributes.newBuilder().setAttribute(SDK_NAME, (Object)"opentelemetry").setAttribute(SDK_LANGUAGE, (Object)"java").setAttribute(SDK_VERSION, (Object)Resource.readVersion()).build());
    private static final Resource DEFAULT = ((EnvAutodetectResource.Builder)((EnvAutodetectResource.Builder)new EnvAutodetectResource.Builder().readEnvironmentVariables()).readSystemProperties()).build().merge(TELEMETRY_SDK).merge(Resource.readResourceFromProviders());

    @Nullable
    private static String readVersion() {
        Properties properties = new Properties();
        try {
            properties.load(Resource.class.getResourceAsStream("/io/opentelemetry/sdk/version.properties"));
        }
        catch (Exception e) {
            return "unknown";
        }
        return properties.getProperty("sdk.version");
    }

    private static Resource readResourceFromProviders() {
        ResourcesConfig resourcesConfig = ((ResourcesConfig.Builder)((ResourcesConfig.Builder)ResourcesConfig.newBuilder().readEnvironmentVariables()).readSystemProperties()).build();
        Resource result = EMPTY;
        for (ResourceProvider resourceProvider : ServiceLoader.load(ResourceProvider.class)) {
            if (resourcesConfig.getDisabledResourceProviders().contains(resourceProvider.getClass().getName())) continue;
            result = result.merge(resourceProvider.create());
        }
        return result;
    }

    Resource() {
    }

    public static Resource getEmpty() {
        return EMPTY;
    }

    public static Resource getTelemetrySdk() {
        return TELEMETRY_SDK;
    }

    public abstract ReadableAttributes getAttributes();

    @Memoized
    public abstract int hashCode();

    public static Resource create(Attributes attributes) {
        Resource.checkAttributes((ReadableAttributes)Objects.requireNonNull(attributes, "attributes"));
        return new AutoValue_Resource((ReadableAttributes)attributes);
    }

    public static Resource getDefault() {
        return DEFAULT;
    }

    public Resource merge(@Nullable Resource other) {
        if (other == null) {
            return this;
        }
        Attributes.Builder attrBuilder = Attributes.newBuilder();
        Merger merger = new Merger(attrBuilder);
        other.getAttributes().forEach((AttributeConsumer)merger);
        this.getAttributes().forEach((AttributeConsumer)merger);
        return new AutoValue_Resource((ReadableAttributes)attrBuilder.build());
    }

    private static void checkAttributes(ReadableAttributes attributes) {
        attributes.forEach(new AttributeConsumer(){

            public <T> void consume(AttributeKey<T> key, T value) {
                Utils.checkArgument((boolean)Resource.isValidAndNotEmpty(key), (String)"Attribute key should be a ASCII string with a length greater than 0 and not exceed 255 characters.");
                Objects.requireNonNull(value, "Attribute value should be a ASCII string with a length not exceed 255 characters.");
            }
        });
    }

    private static boolean isValid(String name) {
        return name.length() <= 255 && StringUtils.isPrintableString((String)name);
    }

    private static boolean isValidAndNotEmpty(AttributeKey<?> name) {
        return !name.getKey().isEmpty() && Resource.isValid(name.getKey());
    }

    private static final class Merger
    implements AttributeConsumer {
        private final Attributes.Builder attrBuilder;

        private Merger(Attributes.Builder attrBuilder) {
            this.attrBuilder = attrBuilder;
        }

        public <T> void consume(AttributeKey<T> key, T value) {
            this.attrBuilder.setAttribute(key, value);
        }
    }
}

