/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.exporter.internal.retry.RetryPolicy;
import io.opentelemetry.exporter.internal.retry.RetryUtil;
import io.opentelemetry.exporter.logging.LoggingMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter;
import io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporterBuilder;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter;
import io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporterBuilder;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServer;
import io.opentelemetry.exporter.prometheus.PrometheusHttpServerBuilder;
import io.opentelemetry.sdk.autoconfigure.ClasspathUtil;
import io.opentelemetry.sdk.autoconfigure.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.OtlpConfigUtil;
import io.opentelemetry.sdk.autoconfigure.SpiUtil;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.metrics.ConfigurableMetricExporterProvider;
import io.opentelemetry.sdk.metrics.SdkMeterProviderBuilder;
import io.opentelemetry.sdk.metrics.export.MetricExporter;
import io.opentelemetry.sdk.metrics.export.MetricReader;
import io.opentelemetry.sdk.metrics.export.PeriodicMetricReader;
import java.time.Duration;
import java.util.function.BiFunction;
import javax.annotation.Nullable;

final class MetricExporterConfiguration {
    static void configureExporter(String name, ConfigProperties config, ClassLoader serviceClassLoader, SdkMeterProviderBuilder sdkMeterProviderBuilder, BiFunction<? super MetricExporter, ConfigProperties, ? extends MetricExporter> metricExporterCustomizer) {
        MetricExporter metricExporter;
        if (name.equals("prometheus")) {
            sdkMeterProviderBuilder.registerMetricReader((MetricReader)MetricExporterConfiguration.configurePrometheusMetricReader(config));
            return;
        }
        switch (name) {
            case "otlp": {
                metricExporter = MetricExporterConfiguration.configureOtlpMetrics(config);
                break;
            }
            case "logging": {
                metricExporter = MetricExporterConfiguration.configureLoggingExporter();
                break;
            }
            default: {
                MetricExporter spiExporter = MetricExporterConfiguration.configureSpiExporter(name, config, serviceClassLoader);
                if (spiExporter == null) {
                    throw new ConfigurationException("Unrecognized value for otel.metrics.exporter: " + name);
                }
                metricExporter = spiExporter;
            }
        }
        metricExporter = metricExporterCustomizer.apply((MetricExporter)metricExporter, config);
        sdkMeterProviderBuilder.registerMetricReader((MetricReader)MetricExporterConfiguration.configurePeriodicMetricReader(config, metricExporter));
    }

    private static MetricExporter configureLoggingExporter() {
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.logging.LoggingMetricExporter", "Logging Metrics Exporter", "opentelemetry-exporter-logging");
        return LoggingMetricExporter.create();
    }

    @Nullable
    static MetricExporter configureSpiExporter(String name, ConfigProperties config, ClassLoader serviceClassLoader) {
        NamedSpiManager<MetricExporter> spiExportersManager = SpiUtil.loadConfigurable(ConfigurableMetricExporterProvider.class, ConfigurableMetricExporterProvider::getName, ConfigurableMetricExporterProvider::createExporter, config, serviceClassLoader);
        return spiExportersManager.getByName(name);
    }

    static MetricExporter configureOtlpMetrics(ConfigProperties config) {
        String protocol = OtlpConfigUtil.getOtlpProtocol("metrics", config);
        if (protocol.equals("http/protobuf")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.http.metrics.OtlpHttpMetricExporter", "OTLP HTTP Metrics Exporter", "opentelemetry-exporter-otlp-http-metrics");
            OtlpHttpMetricExporterBuilder builder = OtlpHttpMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpHttpMetricExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, arg_0 -> ((OtlpHttpMetricExporterBuilder)builder).setAggregationTemporalitySelector(arg_0));
            return builder.build();
        }
        if (protocol.equals("grpc")) {
            ClasspathUtil.checkClassExists("io.opentelemetry.exporter.otlp.metrics.OtlpGrpcMetricExporter", "OTLP gRPC Metrics Exporter", "opentelemetry-exporter-otlp");
            OtlpGrpcMetricExporterBuilder builder = OtlpGrpcMetricExporter.builder();
            OtlpConfigUtil.configureOtlpExporterBuilder("metrics", config, arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setEndpoint(arg_0), (arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).addHeader(arg_0, arg_1), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setCompression(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTimeout(arg_0), arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setTrustedCertificates(arg_0), (arg_0, arg_1) -> ((OtlpGrpcMetricExporterBuilder)builder).setClientTls(arg_0, arg_1), retryPolicy -> RetryUtil.setRetryPolicyOnDelegate((Object)builder, (RetryPolicy)retryPolicy));
            OtlpConfigUtil.configureOtlpAggregationTemporality(config, arg_0 -> ((OtlpGrpcMetricExporterBuilder)builder).setAggregationTemporalitySelector(arg_0));
            return builder.build();
        }
        throw new ConfigurationException("Unsupported OTLP metrics protocol: " + protocol);
    }

    private static PeriodicMetricReader configurePeriodicMetricReader(ConfigProperties config, MetricExporter exporter) {
        Duration exportInterval = config.getDuration("otel.metric.export.interval");
        if (exportInterval == null) {
            exportInterval = Duration.ofMinutes(1L);
        }
        return PeriodicMetricReader.builder((MetricExporter)exporter).setInterval(exportInterval).build();
    }

    private static PrometheusHttpServer configurePrometheusMetricReader(ConfigProperties config) {
        String host;
        ClasspathUtil.checkClassExists("io.opentelemetry.exporter.prometheus.PrometheusHttpServer", "Prometheus Metrics Server", "opentelemetry-exporter-prometheus");
        PrometheusHttpServerBuilder prom = PrometheusHttpServer.builder();
        Integer port = config.getInt("otel.exporter.prometheus.port");
        if (port != null) {
            prom.setPort(port.intValue());
        }
        if ((host = config.getString("otel.exporter.prometheus.host")) != null) {
            prom.setHost(host);
        }
        return prom.build();
    }

    private MetricExporterConfiguration() {
    }
}

