/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.autoconfigure;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.autoconfigure.LogExporterConfiguration;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogLimitsBuilder;
import io.opentelemetry.sdk.logs.LogProcessor;
import io.opentelemetry.sdk.logs.SdkLogEmitterProviderBuilder;
import io.opentelemetry.sdk.logs.export.BatchLogProcessor;
import io.opentelemetry.sdk.logs.export.LogExporter;
import io.opentelemetry.sdk.logs.export.SimpleLogProcessor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;

final class LogEmitterProviderConfiguration {
    static void configureLogEmitterProvider(SdkLogEmitterProviderBuilder logEmitterProviderBuilder, ConfigProperties config, ClassLoader serviceClassLoader, MeterProvider meterProvider, BiFunction<? super LogExporter, ConfigProperties, ? extends LogExporter> logExporterCustomizer) {
        logEmitterProviderBuilder.setLogLimits(() -> LogEmitterProviderConfiguration.configureLogLimits(config));
        Map<String, LogExporter> exportersByName = LogExporterConfiguration.configureLogExporters(config, serviceClassLoader, meterProvider, logExporterCustomizer);
        LogEmitterProviderConfiguration.configureLogProcessors(exportersByName, meterProvider).forEach(arg_0 -> ((SdkLogEmitterProviderBuilder)logEmitterProviderBuilder).addLogProcessor(arg_0));
    }

    static List<LogProcessor> configureLogProcessors(Map<String, LogExporter> exportersByName, MeterProvider meterProvider) {
        HashMap<String, LogExporter> exportersByNameCopy = new HashMap<String, LogExporter>(exportersByName);
        ArrayList<LogProcessor> logProcessors = new ArrayList<LogProcessor>();
        LogExporter exporter = (LogExporter)exportersByNameCopy.remove("logging");
        if (exporter != null) {
            logProcessors.add(SimpleLogProcessor.create((LogExporter)exporter));
        }
        if (!exportersByNameCopy.isEmpty()) {
            LogExporter compositeLogExporter = LogExporter.composite(exportersByNameCopy.values());
            logProcessors.add((LogProcessor)BatchLogProcessor.builder((LogExporter)compositeLogExporter).setMeterProvider(meterProvider).build());
        }
        return logProcessors;
    }

    static LogLimits configureLogLimits(ConfigProperties config) {
        Integer maxAttrs;
        LogLimitsBuilder builder = LogLimits.builder();
        Integer maxAttrLength = config.getInt("otel.attribute.value.length.limit");
        if (maxAttrLength != null) {
            builder.setMaxAttributeValueLength(maxAttrLength.intValue());
        }
        if ((maxAttrs = config.getInt("otel.attribute.count.limit")) != null) {
            builder.setMaxNumberOfAttributes(maxAttrs.intValue());
        }
        return builder.build();
    }

    private LogEmitterProviderConfiguration() {
    }
}

