/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.SpanExporterFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.BatchSpanProcessor;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SimpleSpanProcessor;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanProcessor;
import io.opentelemetry.sdk.trace.export.BatchSpanProcessorBuilder;
import java.io.Closeable;
import java.time.Duration;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

final class SpanProcessorFactory
implements Factory<SpanProcessor, io.opentelemetry.sdk.trace.SpanProcessor> {
    private static final SpanProcessorFactory INSTANCE = new SpanProcessorFactory();

    private SpanProcessorFactory() {
    }

    static SpanProcessorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.trace.SpanProcessor create(@Nullable SpanProcessor model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model == null) {
            return io.opentelemetry.sdk.trace.SpanProcessor.composite((io.opentelemetry.sdk.trace.SpanProcessor[])new io.opentelemetry.sdk.trace.SpanProcessor[0]);
        }
        BatchSpanProcessor batchModel = model.getBatch();
        if (batchModel != null) {
            SpanExporter exporterModel = batchModel.getExporter();
            if (exporterModel == null) {
                return io.opentelemetry.sdk.trace.SpanProcessor.composite((io.opentelemetry.sdk.trace.SpanProcessor[])new io.opentelemetry.sdk.trace.SpanProcessor[0]);
            }
            BatchSpanProcessorBuilder builder = io.opentelemetry.sdk.trace.export.BatchSpanProcessor.builder((io.opentelemetry.sdk.trace.export.SpanExporter)SpanExporterFactory.getInstance().create(exporterModel, spiHelper, closeables));
            if (batchModel.getExportTimeout() != null) {
                builder.setExporterTimeout(Duration.ofMillis(batchModel.getExportTimeout().intValue()));
            }
            if (batchModel.getMaxExportBatchSize() != null) {
                builder.setMaxExportBatchSize(batchModel.getMaxExportBatchSize().intValue());
            }
            if (batchModel.getMaxQueueSize() != null) {
                builder.setMaxQueueSize(batchModel.getMaxQueueSize().intValue());
            }
            if (batchModel.getScheduleDelay() != null) {
                builder.setScheduleDelay(Duration.ofMillis(batchModel.getScheduleDelay().intValue()));
            }
            return (io.opentelemetry.sdk.trace.SpanProcessor)FileConfigUtil.addAndReturn(closeables, builder.build());
        }
        SimpleSpanProcessor simpleModel = model.getSimple();
        if (simpleModel != null) {
            SpanExporter exporterModel = simpleModel.getExporter();
            if (exporterModel == null) {
                return io.opentelemetry.sdk.trace.SpanProcessor.composite((io.opentelemetry.sdk.trace.SpanProcessor[])new io.opentelemetry.sdk.trace.SpanProcessor[0]);
            }
            return FileConfigUtil.addAndReturn(closeables, io.opentelemetry.sdk.trace.export.SimpleSpanProcessor.create((io.opentelemetry.sdk.trace.export.SpanExporter)SpanExporterFactory.getInstance().create(exporterModel, spiHelper, closeables)));
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            throw new ConfigurationException("Unrecognized span processor(s): " + model.getAdditionalProperties().keySet().stream().collect(Collectors.joining(",", "[", "]")));
        }
        return io.opentelemetry.sdk.trace.SpanProcessor.composite((io.opentelemetry.sdk.trace.SpanProcessor[])new io.opentelemetry.sdk.trace.SpanProcessor[0]);
    }
}

