/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.MetricExporter;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.OtlpMetric;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

final class MetricExporterFactory
implements Factory<MetricExporter, io.opentelemetry.sdk.metrics.export.MetricExporter> {
    private static final MetricExporterFactory INSTANCE = new MetricExporterFactory();

    private MetricExporterFactory() {
    }

    static MetricExporterFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.metrics.export.MetricExporter create(MetricExporter model, SpiHelper spiHelper, List<Closeable> closeables) {
        OtlpMetric otlpModel = model.getOtlp();
        if (otlpModel != null) {
            model.getAdditionalProperties().put("otlp", otlpModel);
        }
        if (model.getConsole() != null) {
            model.getAdditionalProperties().put("console", model.getConsole());
        }
        if (model.getPrometheus() != null) {
            throw new ConfigurationException("prometheus exporter not supported in this context");
        }
        if (!model.getAdditionalProperties().isEmpty()) {
            Map<String, Object> additionalProperties = model.getAdditionalProperties();
            if (additionalProperties.size() > 1) {
                throw new ConfigurationException("Invalid configuration - multiple metric exporters set: " + additionalProperties.keySet().stream().collect(Collectors.joining(",", "[", "]")));
            }
            Map.Entry exporterKeyValue = (Map.Entry)additionalProperties.entrySet().stream().findFirst().orElseThrow(() -> new IllegalStateException("Missing exporter. This is a programming error."));
            io.opentelemetry.sdk.metrics.export.MetricExporter metricExporter = FileConfigUtil.loadComponent(spiHelper, io.opentelemetry.sdk.metrics.export.MetricExporter.class, (String)exporterKeyValue.getKey(), exporterKeyValue.getValue());
            return FileConfigUtil.addAndReturn(closeables, metricExporter);
        }
        throw new ConfigurationException("metric exporter must be set");
    }
}

