/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.SpanLimitsAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.AttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.SpanLimits;
import io.opentelemetry.sdk.trace.SpanLimitsBuilder;
import java.io.Closeable;
import java.util.List;

final class SpanLimitsFactory
implements Factory<SpanLimitsAndAttributeLimits, io.opentelemetry.sdk.trace.SpanLimits> {
    private static final SpanLimitsFactory INSTANCE = new SpanLimitsFactory();

    private SpanLimitsFactory() {
    }

    static SpanLimitsFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public io.opentelemetry.sdk.trace.SpanLimits create(SpanLimitsAndAttributeLimits model, SpiHelper spiHelper, List<Closeable> closeables) {
        SpanLimits spanLimitsModel;
        SpanLimitsBuilder builder = io.opentelemetry.sdk.trace.SpanLimits.builder();
        AttributeLimits attributeLimitsModel = model.getAttributeLimits();
        if (attributeLimitsModel != null) {
            if (attributeLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(attributeLimitsModel.getAttributeCountLimit().intValue());
            }
            if (attributeLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(attributeLimitsModel.getAttributeValueLengthLimit().intValue());
            }
        }
        if ((spanLimitsModel = model.getSpanLimits()) != null) {
            if (spanLimitsModel.getAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributes(spanLimitsModel.getAttributeCountLimit().intValue());
            }
            if (spanLimitsModel.getAttributeValueLengthLimit() != null) {
                builder.setMaxAttributeValueLength(spanLimitsModel.getAttributeValueLengthLimit().intValue());
            }
            if (spanLimitsModel.getEventCountLimit() != null) {
                builder.setMaxNumberOfEvents(spanLimitsModel.getEventCountLimit().intValue());
            }
            if (spanLimitsModel.getLinkCountLimit() != null) {
                builder.setMaxNumberOfLinks(spanLimitsModel.getLinkCountLimit().intValue());
            }
            if (spanLimitsModel.getEventAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributesPerEvent(spanLimitsModel.getEventAttributeCountLimit().intValue());
            }
            if (spanLimitsModel.getLinkAttributeCountLimit() != null) {
                builder.setMaxNumberOfAttributesPerLink(spanLimitsModel.getLinkAttributeCountLimit().intValue());
            }
        }
        return builder.build();
    }
}

