/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.api.baggage.propagation.W3CBaggagePropagator;
import io.opentelemetry.api.trace.propagation.W3CTraceContextPropagator;
import io.opentelemetry.context.propagation.TextMapPropagator;
import io.opentelemetry.sdk.autoconfigure.internal.NamedSpiManager;
import io.opentelemetry.sdk.autoconfigure.internal.SpiHelper;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigProperties;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurablePropagatorProvider;
import io.opentelemetry.sdk.autoconfigure.spi.ConfigurationException;
import io.opentelemetry.sdk.autoconfigure.spi.internal.DefaultConfigProperties;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import java.io.Closeable;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;

final class TextMapPropagatorFactory
implements Factory<List<String>, TextMapPropagator> {
    private static final TextMapPropagatorFactory INSTANCE = new TextMapPropagatorFactory();

    private TextMapPropagatorFactory() {
    }

    static TextMapPropagatorFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public TextMapPropagator create(List<String> model, SpiHelper spiHelper, List<Closeable> closeables) {
        if (model.isEmpty()) {
            model = Arrays.asList("tracecontext", "baggage");
        }
        if (model.contains("none")) {
            if (model.size() > 1) {
                throw new ConfigurationException("propagators contains \"none\" along with other propagators");
            }
            return TextMapPropagator.noop();
        }
        NamedSpiManager spiPropagatorsManager = spiHelper.loadConfigurable(ConfigurablePropagatorProvider.class, ConfigurablePropagatorProvider::getName, ConfigurablePropagatorProvider::getPropagator, (ConfigProperties)DefaultConfigProperties.createFromMap(Collections.emptyMap()));
        LinkedHashSet<TextMapPropagator> propagators = new LinkedHashSet<TextMapPropagator>();
        for (String propagator : model) {
            propagators.add(TextMapPropagatorFactory.getPropagator(propagator, (NamedSpiManager<TextMapPropagator>)spiPropagatorsManager));
        }
        return TextMapPropagator.composite(propagators);
    }

    private static TextMapPropagator getPropagator(String name, NamedSpiManager<TextMapPropagator> spiPropagatorsManager) {
        if (name.equals("tracecontext")) {
            return W3CTraceContextPropagator.getInstance();
        }
        if (name.equals("baggage")) {
            return W3CBaggagePropagator.getInstance();
        }
        TextMapPropagator spiPropagator = (TextMapPropagator)spiPropagatorsManager.getByName(name);
        if (spiPropagator != null) {
            return spiPropagator;
        }
        throw new ConfigurationException("Unrecognized propagator: " + name);
    }
}

