/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.fileconfig;

import io.opentelemetry.sdk.extension.incubator.fileconfig.DeclarativeConfigContext;
import io.opentelemetry.sdk.extension.incubator.fileconfig.Factory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.FileConfigUtil;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogLimitsFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordLimitsAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LogRecordProcessorFactory;
import io.opentelemetry.sdk.extension.incubator.fileconfig.LoggerProviderAndAttributeLimits;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalLoggerConfigModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalLoggerConfiguratorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.ExperimentalLoggerMatcherAndConfigModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LogRecordProcessorModel;
import io.opentelemetry.sdk.extension.incubator.fileconfig.internal.model.LoggerProviderModel;
import io.opentelemetry.sdk.internal.ScopeConfigurator;
import io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.SdkLoggerProvider;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.internal.LoggerConfig;
import io.opentelemetry.sdk.logs.internal.SdkLoggerProviderUtil;
import java.util.List;

final class LoggerProviderFactory
implements Factory<LoggerProviderAndAttributeLimits, SdkLoggerProviderBuilder> {
    private static final LoggerProviderFactory INSTANCE = new LoggerProviderFactory();

    private LoggerProviderFactory() {
    }

    static LoggerProviderFactory getInstance() {
        return INSTANCE;
    }

    @Override
    public SdkLoggerProviderBuilder create(LoggerProviderAndAttributeLimits model, DeclarativeConfigContext context) {
        ExperimentalLoggerConfiguratorModel loggerConfiguratorModel;
        SdkLoggerProviderBuilder builder = SdkLoggerProvider.builder();
        LoggerProviderModel loggerProviderModel = model.getLoggerProvider();
        if (loggerProviderModel == null) {
            return builder;
        }
        LogLimits logLimits = LogLimitsFactory.getInstance().create(LogRecordLimitsAndAttributeLimits.create(model.getAttributeLimits(), loggerProviderModel.getLimits()), context);
        builder.setLogLimits(() -> logLimits);
        List<LogRecordProcessorModel> processors = loggerProviderModel.getProcessors();
        if (processors != null) {
            processors.forEach(processor -> builder.addLogRecordProcessor(LogRecordProcessorFactory.getInstance().create((LogRecordProcessorModel)processor, context)));
        }
        if ((loggerConfiguratorModel = loggerProviderModel.getLoggerConfiguratorDevelopment()) != null) {
            List<ExperimentalLoggerMatcherAndConfigModel> loggerMatcherAndConfigs;
            ExperimentalLoggerConfigModel defaultConfigModel = loggerConfiguratorModel.getDefaultConfig();
            ScopeConfiguratorBuilder configuratorBuilder = ScopeConfigurator.builder();
            if (defaultConfigModel != null) {
                configuratorBuilder.setDefault((Object)LoggerConfigFactory.INSTANCE.create(defaultConfigModel, context));
            }
            if ((loggerMatcherAndConfigs = loggerConfiguratorModel.getLoggers()) != null) {
                for (ExperimentalLoggerMatcherAndConfigModel loggerMatcherAndConfig : loggerMatcherAndConfigs) {
                    String name = FileConfigUtil.requireNonNull(loggerMatcherAndConfig.getName(), "logger matcher name");
                    ExperimentalLoggerConfigModel config = loggerMatcherAndConfig.getConfig();
                    if (name == null || config == null) continue;
                    configuratorBuilder.addCondition(ScopeConfiguratorBuilder.nameMatchesGlob((String)name), (Object)LoggerConfigFactory.INSTANCE.create(config, context));
                }
            }
            SdkLoggerProviderUtil.setLoggerConfigurator((SdkLoggerProviderBuilder)builder, (ScopeConfigurator)configuratorBuilder.build());
        }
        return builder;
    }

    private static class LoggerConfigFactory
    implements Factory<ExperimentalLoggerConfigModel, LoggerConfig> {
        private static final LoggerConfigFactory INSTANCE = new LoggerConfigFactory();

        private LoggerConfigFactory() {
        }

        @Override
        public LoggerConfig create(ExperimentalLoggerConfigModel model, DeclarativeConfigContext context) {
            if (model.getDisabled() != null && model.getDisabled().booleanValue()) {
                return LoggerConfig.disabled();
            }
            return LoggerConfig.defaultConfig();
        }
    }
}

