/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.incubator.trace.samplers;

import com.google.auto.value.AutoValue;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.AutoValue_ImmutableSamplingIntent;
import io.opentelemetry.sdk.extension.incubator.trace.samplers.SamplingIntent;
import java.util.function.Function;

@AutoValue
abstract class ImmutableSamplingIntent
implements SamplingIntent {
    private static final int RANDOM_VALUE_BITS = 56;
    static final long INVALID_THRESHOLD = -1L;
    static final long INVALID_RANDOM_VALUE = -1L;
    static final long MIN_THRESHOLD = 0L;
    static final long MAX_THRESHOLD = 0x100000000000000L;
    static final long MAX_RANDOM_VALUE = 0xFFFFFFFFFFFFFFL;

    ImmutableSamplingIntent() {
    }

    static boolean isValidThreshold(long threshold) {
        return threshold >= 0L && threshold <= 0x100000000000000L;
    }

    static boolean isValidRandomValue(long randomValue) {
        return randomValue >= 0L && randomValue <= 0xFFFFFFFFFFFFFFL;
    }

    static ImmutableSamplingIntent create(long threshold, boolean thresholdReliable, Attributes attributes, Function<TraceState, TraceState> traceStateUpdater) {
        return new AutoValue_ImmutableSamplingIntent(threshold, thresholdReliable, attributes, traceStateUpdater);
    }
}

