/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.trace.jaeger.sampler;

import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.exporter.internal.ExporterBuilderUtil;
import io.opentelemetry.exporter.internal.TlsConfigHelper;
import io.opentelemetry.exporter.internal.okhttp.OkHttpUtil;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.GrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.JaegerRemoteSampler;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.MarshallerRemoteSamplerServiceGrpc;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.OkHttpGrpcService;
import io.opentelemetry.sdk.extension.trace.jaeger.sampler.UpstreamGrpcService;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.net.URI;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import okhttp3.Headers;
import okhttp3.OkHttpClient;
import okhttp3.Protocol;

public final class JaegerRemoteSamplerBuilder {
    private static final String GRPC_SERVICE_NAME = "jaeger.api_v2.SamplingManager";
    static final String GRPC_ENDPOINT_PATH = "/jaeger.api_v2.SamplingManager/GetSamplingStrategy";
    private static final String DEFAULT_ENDPOINT_URL = "http://localhost:14250";
    private static final URI DEFAULT_ENDPOINT = URI.create("http://localhost:14250");
    private static final int DEFAULT_POLLING_INTERVAL_MILLIS = 60000;
    private static final Sampler INITIAL_SAMPLER = Sampler.parentBased((Sampler)Sampler.traceIdRatioBased((double)0.001));
    private static final long DEFAULT_TIMEOUT_SECS = 10L;
    private URI endpoint = DEFAULT_ENDPOINT;
    private Sampler initialSampler = INITIAL_SAMPLER;
    private int pollingIntervalMillis = 60000;
    private final TlsConfigHelper tlsConfigHelper = new TlsConfigHelper();
    @Nullable
    private String serviceName;
    @Nullable
    private Object grpcChannel;

    JaegerRemoteSamplerBuilder() {
    }

    public JaegerRemoteSamplerBuilder setServiceName(String serviceName) {
        Objects.requireNonNull(serviceName, "serviceName");
        this.serviceName = serviceName;
        return this;
    }

    public JaegerRemoteSamplerBuilder setEndpoint(String endpoint) {
        Objects.requireNonNull(endpoint, "endpoint");
        this.endpoint = ExporterBuilderUtil.validateEndpoint((String)endpoint);
        return this;
    }

    public JaegerRemoteSamplerBuilder setTrustedCertificates(byte[] trustedCertificatesPem) {
        Objects.requireNonNull(trustedCertificatesPem, "trustedCertificatesPem");
        this.tlsConfigHelper.createTrustManager(trustedCertificatesPem);
        return this;
    }

    public JaegerRemoteSamplerBuilder setClientTls(byte[] privateKeyPem, byte[] certificatePem) {
        Objects.requireNonNull(privateKeyPem, "privateKeyPem");
        Objects.requireNonNull(certificatePem, "certificatePem");
        this.tlsConfigHelper.createKeyManager(privateKeyPem, certificatePem);
        return this;
    }

    public JaegerRemoteSamplerBuilder setPollingInterval(int interval, TimeUnit unit) {
        Objects.requireNonNull(unit, "unit");
        Utils.checkArgument((interval > 0 ? 1 : 0) != 0, (String)"polling interval must be positive");
        this.pollingIntervalMillis = (int)unit.toMillis(interval);
        return this;
    }

    public JaegerRemoteSamplerBuilder setPollingInterval(Duration interval) {
        Objects.requireNonNull(interval, "interval");
        return this.setPollingInterval((int)interval.toMillis(), TimeUnit.MILLISECONDS);
    }

    public JaegerRemoteSamplerBuilder setInitialSampler(Sampler initialSampler) {
        Objects.requireNonNull(initialSampler, "initialSampler");
        this.initialSampler = initialSampler;
        return this;
    }

    @Deprecated
    public JaegerRemoteSamplerBuilder setChannel(ManagedChannel channel) {
        Objects.requireNonNull(channel, "channel");
        this.grpcChannel = channel;
        return this;
    }

    public JaegerRemoteSampler build() {
        if (this.grpcChannel != null) {
            return new JaegerRemoteSampler(UpstreamGrpcExporterFactory.buildWithChannel((ManagedChannel)this.grpcChannel), this.serviceName, this.pollingIntervalMillis, this.initialSampler);
        }
        OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher());
        clientBuilder.callTimeout(Duration.ofNanos(TimeUnit.SECONDS.toNanos(10L)));
        this.tlsConfigHelper.configureWithSocketFactory((arg_0, arg_1) -> ((OkHttpClient.Builder)clientBuilder).sslSocketFactory(arg_0, arg_1));
        String endpoint = this.endpoint.resolve(GRPC_ENDPOINT_PATH).toString();
        if (endpoint.startsWith("http://")) {
            clientBuilder.protocols(Collections.singletonList(Protocol.H2_PRIOR_KNOWLEDGE));
        } else {
            clientBuilder.protocols(Arrays.asList(Protocol.HTTP_2, Protocol.HTTP_1_1));
        }
        Headers.Builder headers = new Headers.Builder();
        headers.add("te", "trailers");
        return new JaegerRemoteSampler(new OkHttpGrpcService("remoteSampling", clientBuilder.build(), endpoint, headers.build()), this.serviceName, this.pollingIntervalMillis, this.initialSampler);
    }

    private static class UpstreamGrpcExporterFactory {
        private UpstreamGrpcExporterFactory() {
        }

        private static GrpcService buildWithChannel(ManagedChannel channel) {
            return new UpstreamGrpcService("remoteSampling", channel, MarshallerRemoteSamplerServiceGrpc.newFutureStub((Channel)channel), TimeUnit.SECONDS.toNanos(10L));
        }
    }
}

