/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.extension.resources;

import java.lang.management.ManagementFactory;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
final class ProcessPid {
    private ProcessPid() {
    }

    @IgnoreJRERequirement
    static long getPid() {
        String runtimeName = ManagementFactory.getRuntimeMXBean().getName();
        int atIndex = runtimeName.indexOf(64);
        if (atIndex >= 0) {
            String pidString = runtimeName.substring(0, atIndex);
            try {
                return Long.parseLong(pidString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1L;
    }
}

