/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.logs.LoggerBuilder;
import io.opentelemetry.api.logs.LoggerProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ComponentRegistry;
import io.opentelemetry.sdk.internal.ScopeConfigurator;
import io.opentelemetry.sdk.logs.LogLimits;
import io.opentelemetry.sdk.logs.LogRecordProcessor;
import io.opentelemetry.sdk.logs.LoggerSharedState;
import io.opentelemetry.sdk.logs.NoopLogRecordProcessor;
import io.opentelemetry.sdk.logs.SdkLogger;
import io.opentelemetry.sdk.logs.SdkLoggerBuilder;
import io.opentelemetry.sdk.logs.SdkLoggerProviderBuilder;
import io.opentelemetry.sdk.logs.internal.LoggerConfig;
import io.opentelemetry.sdk.resources.Resource;
import java.io.Closeable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SdkLoggerProvider
implements LoggerProvider,
Closeable {
    static final String DEFAULT_LOGGER_NAME = "unknown";
    private static final Logger LOGGER = Logger.getLogger(SdkLoggerProvider.class.getName());
    private final LoggerSharedState sharedState;
    private final ComponentRegistry<SdkLogger> loggerComponentRegistry;
    private final boolean isNoopLogRecordProcessor;
    private ScopeConfigurator<LoggerConfig> loggerConfigurator;

    public static SdkLoggerProviderBuilder builder() {
        return new SdkLoggerProviderBuilder();
    }

    SdkLoggerProvider(Resource resource, Supplier<LogLimits> logLimitsSupplier, List<LogRecordProcessor> processors, Clock clock, ScopeConfigurator<LoggerConfig> loggerConfigurator) {
        LogRecordProcessor logRecordProcessor = LogRecordProcessor.composite(processors);
        this.sharedState = new LoggerSharedState(resource, logLimitsSupplier, logRecordProcessor, clock);
        this.loggerComponentRegistry = new ComponentRegistry(instrumentationScopeInfo -> SdkLogger.create(this.sharedState, instrumentationScopeInfo, this.getLoggerConfig((InstrumentationScopeInfo)instrumentationScopeInfo)));
        this.loggerConfigurator = loggerConfigurator;
        this.isNoopLogRecordProcessor = logRecordProcessor instanceof NoopLogRecordProcessor;
    }

    private LoggerConfig getLoggerConfig(InstrumentationScopeInfo instrumentationScopeInfo) {
        LoggerConfig loggerConfig = (LoggerConfig)this.loggerConfigurator.apply((Object)instrumentationScopeInfo);
        return loggerConfig == null ? LoggerConfig.defaultConfig() : loggerConfig;
    }

    public io.opentelemetry.api.logs.Logger get(String instrumentationScopeName) {
        return (io.opentelemetry.api.logs.Logger)this.loggerComponentRegistry.get(SdkLoggerProvider.instrumentationNameOrDefault(instrumentationScopeName), null, null, Attributes.empty());
    }

    public LoggerBuilder loggerBuilder(String instrumentationScopeName) {
        if (this.isNoopLogRecordProcessor) {
            return LoggerProvider.noop().loggerBuilder(instrumentationScopeName);
        }
        return new SdkLoggerBuilder(this.loggerComponentRegistry, SdkLoggerProvider.instrumentationNameOrDefault(instrumentationScopeName));
    }

    private static String instrumentationNameOrDefault(@Nullable String instrumentationScopeName) {
        if (instrumentationScopeName == null || instrumentationScopeName.isEmpty()) {
            LOGGER.fine("Logger requested without instrumentation scope name.");
            return DEFAULT_LOGGER_NAME;
        }
        return instrumentationScopeName;
    }

    void setLoggerConfigurator(ScopeConfigurator<LoggerConfig> loggerConfigurator) {
        this.loggerConfigurator = loggerConfigurator;
        this.loggerComponentRegistry.getComponents().forEach(sdkLogger -> sdkLogger.updateLoggerConfig(this.getLoggerConfig(sdkLogger.getInstrumentationScopeInfo())));
    }

    public CompletableResultCode forceFlush() {
        return this.sharedState.getLogRecordProcessor().forceFlush();
    }

    public CompletableResultCode shutdown() {
        if (this.sharedState.hasBeenShutdown()) {
            LOGGER.log(Level.INFO, "Calling shutdown() multiple times.");
            return CompletableResultCode.ofSuccess();
        }
        return this.sharedState.shutdown();
    }

    @Override
    public void close() {
        this.shutdown().join(10L, TimeUnit.SECONDS);
    }

    public String toString() {
        return "SdkLoggerProvider{clock=" + this.sharedState.getClock() + ", resource=" + this.sharedState.getResource() + ", logLimits=" + this.sharedState.getLogLimits() + ", logRecordProcessor=" + this.sharedState.getLogRecordProcessor() + ", loggerConfigurator=" + this.loggerConfigurator + '}';
    }
}

