/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.logs.export;

import io.opentelemetry.api.internal.Utils;
import io.opentelemetry.sdk.logs.export.BatchLogProcessor;
import io.opentelemetry.sdk.logs.export.LogExporter;
import java.util.Objects;

public final class BatchLogProcessorBuilder {
    private static final long DEFAULT_SCHEDULE_DELAY_MILLIS = 200L;
    private static final int DEFAULT_MAX_QUEUE_SIZE = 2048;
    private static final int DEFAULT_MAX_EXPORT_BATCH_SIZE = 512;
    private static final long DEFAULT_EXPORT_TIMEOUT_MILLIS = 30000L;
    private final LogExporter logExporter;
    private long scheduleDelayMillis = 200L;
    private int maxQueueSize = 2048;
    private int maxExportBatchSize = 512;
    private long exporterTimeoutMillis = 30000L;

    BatchLogProcessorBuilder(LogExporter logExporter) {
        this.logExporter = Objects.requireNonNull(logExporter, "Exporter argument can not be null");
    }

    public BatchLogProcessor build() {
        return new BatchLogProcessor(this.maxQueueSize, this.scheduleDelayMillis, this.maxExportBatchSize, this.exporterTimeoutMillis, this.logExporter);
    }

    public BatchLogProcessorBuilder setScheduleDelayMillis(long scheduleDelayMillis) {
        this.scheduleDelayMillis = scheduleDelayMillis;
        return this;
    }

    public long getScheduleDelayMillis() {
        return this.scheduleDelayMillis;
    }

    public BatchLogProcessorBuilder setExporterTimeoutMillis(int exporterTimeoutMillis) {
        this.exporterTimeoutMillis = exporterTimeoutMillis;
        return this;
    }

    public long getExporterTimeoutMillis() {
        return this.exporterTimeoutMillis;
    }

    public BatchLogProcessorBuilder setMaxQueueSize(int maxQueueSize) {
        this.maxQueueSize = maxQueueSize;
        return this;
    }

    public int getMaxQueueSize() {
        return this.maxQueueSize;
    }

    public BatchLogProcessorBuilder setMaxExportBatchSize(int maxExportBatchSize) {
        Utils.checkArgument((maxExportBatchSize > 0 ? 1 : 0) != 0, (String)"maxExportBatchSize must be positive.");
        this.maxExportBatchSize = maxExportBatchSize;
        return this;
    }

    public int getMaxExportBatchSize() {
        return this.maxExportBatchSize;
    }
}

