/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.metrics.SynchronousInstrument;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import java.util.concurrent.atomic.AtomicLong;

abstract class AbstractBoundInstrument
implements SynchronousInstrument.BoundInstrument {
    private final AtomicLong refCountMapped = new AtomicLong(2L);
    private final Aggregator aggregator;

    AbstractBoundInstrument(Aggregator aggregator) {
        this.aggregator = aggregator;
    }

    final boolean bind() {
        return (this.refCountMapped.addAndGet(2L) & 1L) == 0L;
    }

    public final void unbind() {
        this.refCountMapped.getAndAdd(-2L);
    }

    final boolean tryUnmap() {
        if (this.refCountMapped.get() != 0L) {
            return false;
        }
        return this.refCountMapped.compareAndSet(0L, 1L);
    }

    final void recordLong(long value) {
        this.aggregator.recordLong(value);
    }

    final void recordDouble(double value) {
        this.aggregator.recordDouble(value);
    }

    final Aggregator getAggregator() {
        return this.aggregator;
    }
}

