/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.common.Labels;
import io.opentelemetry.metrics.LongValueRecorder;
import io.opentelemetry.sdk.metrics.AbstractBoundInstrument;
import io.opentelemetry.sdk.metrics.AbstractInstrument;
import io.opentelemetry.sdk.metrics.AbstractSynchronousInstrument;
import io.opentelemetry.sdk.metrics.ActiveBatcher;
import io.opentelemetry.sdk.metrics.Batcher;
import io.opentelemetry.sdk.metrics.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.MeterProviderSharedState;
import io.opentelemetry.sdk.metrics.MeterSdk;
import io.opentelemetry.sdk.metrics.MeterSharedState;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.common.InstrumentValueType;

final class LongValueRecorderSdk
extends AbstractSynchronousInstrument<BoundInstrument>
implements LongValueRecorder {
    private LongValueRecorderSdk(InstrumentDescriptor descriptor, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, Batcher batcher) {
        super(descriptor, meterProviderSharedState, meterSharedState, new ActiveBatcher(batcher));
    }

    public void record(long value, Labels labels) {
        BoundInstrument boundInstrument = (BoundInstrument)this.bind(labels);
        boundInstrument.record(value);
        boundInstrument.unbind();
    }

    public void record(long value) {
        this.record(value, Labels.empty());
    }

    @Override
    BoundInstrument newBinding(Batcher batcher) {
        return new BoundInstrument(batcher);
    }

    static final class Builder
    extends AbstractInstrument.Builder<Builder>
    implements LongValueRecorder.Builder {
        Builder(String name, MeterProviderSharedState meterProviderSharedState, MeterSharedState meterSharedState, MeterSdk meterSdk) {
            super(name, meterProviderSharedState, meterSharedState, meterSdk);
        }

        @Override
        Builder getThis() {
            return this;
        }

        public LongValueRecorderSdk build() {
            InstrumentDescriptor descriptor = this.getInstrumentDescriptor(InstrumentType.VALUE_RECORDER, InstrumentValueType.LONG);
            return this.register(new LongValueRecorderSdk(descriptor, this.getMeterProviderSharedState(), this.getMeterSharedState(), this.getBatcher(descriptor)));
        }
    }

    static final class BoundInstrument
    extends AbstractBoundInstrument
    implements LongValueRecorder.BoundLongValueRecorder {
        BoundInstrument(Batcher batcher) {
            super(batcher.getAggregator());
        }

        public void record(long value) {
            this.recordLong(value);
        }
    }
}

