/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.aggregator;

import com.google.common.util.concurrent.AtomicDouble;
import io.opentelemetry.common.Labels;
import io.opentelemetry.sdk.metrics.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.data.MetricData;

public final class DoubleSumAggregator
extends AbstractAggregator {
    private static final double DEFAULT_VALUE = 0.0;
    private static final AggregatorFactory AGGREGATOR_FACTORY = new AggregatorFactory(){

        @Override
        public Aggregator getAggregator() {
            return new DoubleSumAggregator();
        }
    };
    private final AtomicDouble current = new AtomicDouble(0.0);

    public static AggregatorFactory getFactory() {
        return AGGREGATOR_FACTORY;
    }

    @Override
    void doMergeAndReset(Aggregator aggregator) {
        DoubleSumAggregator other = (DoubleSumAggregator)aggregator;
        other.current.getAndAdd(this.current.getAndSet(0.0));
    }

    @Override
    public MetricData.Point toPoint(long startEpochNanos, long epochNanos, Labels labels) {
        return MetricData.DoublePoint.create(startEpochNanos, epochNanos, labels, this.current.get());
    }

    @Override
    public void doRecordDouble(double value) {
        this.current.getAndAdd(value);
    }
}

