/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics;

import io.opentelemetry.sdk.metrics.aggregator.AggregatorFactory;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.view.InstrumentSelector;
import io.opentelemetry.sdk.metrics.view.View;
import java.util.EnumMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Pattern;

final class ViewRegistry {
    private static final LinkedHashMap<Pattern, View> EMPTY_CONFIG = new LinkedHashMap();
    static final View CUMULATIVE_SUM = View.builder().setAggregatorFactory(AggregatorFactory.sum(true)).build();
    static final View SUMMARY = View.builder().setAggregatorFactory(AggregatorFactory.minMaxSumCount()).build();
    static final View LAST_VALUE = View.builder().setAggregatorFactory(AggregatorFactory.lastValue()).build();
    private final ReentrantLock lock = new ReentrantLock();
    private volatile EnumMap<InstrumentType, LinkedHashMap<Pattern, View>> configuration = new EnumMap(InstrumentType.class);

    ViewRegistry() {
        this.configuration.put(InstrumentType.COUNTER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.UP_DOWN_COUNTER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.VALUE_RECORDER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.SUM_OBSERVER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.UP_DOWN_SUM_OBSERVER, EMPTY_CONFIG);
        this.configuration.put(InstrumentType.VALUE_OBSERVER, EMPTY_CONFIG);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerView(InstrumentSelector selector, View view) {
        this.lock.lock();
        try {
            EnumMap<InstrumentType, LinkedHashMap<Pattern, View>> newConfiguration = new EnumMap<InstrumentType, LinkedHashMap<Pattern, View>>(this.configuration);
            newConfiguration.put(selector.getInstrumentType(), ViewRegistry.newLinkedHashMap(selector.getInstrumentNamePattern(), view, newConfiguration.get((Object)selector.getInstrumentType())));
            this.configuration = newConfiguration;
        }
        finally {
            this.lock.unlock();
        }
    }

    View findView(InstrumentDescriptor descriptor) {
        LinkedHashMap<Pattern, View> configPerType = this.configuration.get((Object)descriptor.getType());
        for (Map.Entry<Pattern, View> entry : configPerType.entrySet()) {
            if (!entry.getKey().matcher(descriptor.getName()).matches()) continue;
            return entry.getValue();
        }
        return ViewRegistry.getDefaultSpecification(descriptor);
    }

    private static View getDefaultSpecification(InstrumentDescriptor descriptor) {
        switch (descriptor.getType()) {
            case COUNTER: 
            case UP_DOWN_COUNTER: 
            case SUM_OBSERVER: 
            case UP_DOWN_SUM_OBSERVER: {
                return CUMULATIVE_SUM;
            }
            case VALUE_RECORDER: {
                return SUMMARY;
            }
            case VALUE_OBSERVER: {
                return LAST_VALUE;
            }
        }
        throw new IllegalArgumentException("Unknown descriptor type: " + (Object)((Object)descriptor.getType()));
    }

    private static LinkedHashMap<Pattern, View> newLinkedHashMap(Pattern pattern, View view, LinkedHashMap<Pattern, View> parentConfiguration) {
        LinkedHashMap<Pattern, View> result = new LinkedHashMap<Pattern, View>();
        result.put(pattern, view);
        result.putAll(parentConfiguration);
        return result;
    }
}

