/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.state;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.internal.ThrottlingLogger;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.descriptor.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.internal.export.CollectionHandle;
import io.opentelemetry.sdk.metrics.internal.state.BoundStorageHandle;
import io.opentelemetry.sdk.metrics.internal.state.DeltaAccumulation;
import io.opentelemetry.sdk.metrics.internal.state.MetricStorageUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
class DeltaMetricStorage<T> {
    private static final ThrottlingLogger logger = new ThrottlingLogger(Logger.getLogger(DeltaMetricStorage.class.getName()));
    private static final BoundStorageHandle NOOP_STORAGE_HANDLE = new NoopBoundHandle();
    private final Aggregator<T> aggregator;
    private final InstrumentDescriptor instrument;
    private final ConcurrentHashMap<Attributes, AggregatorHandle<T>> activeCollectionStorage = new ConcurrentHashMap();
    private final List<DeltaAccumulation<T>> unreportedDeltas = new ArrayList<DeltaAccumulation<T>>();

    DeltaMetricStorage(Aggregator<T> aggregator, InstrumentDescriptor instrument) {
        this.aggregator = aggregator;
        this.instrument = instrument;
    }

    public BoundStorageHandle bind(Attributes attributes) {
        AggregatorHandle<T> aggregatorHandle = this.activeCollectionStorage.get(attributes);
        if (aggregatorHandle != null && aggregatorHandle.acquire()) {
            return aggregatorHandle;
        }
        aggregatorHandle = this.aggregator.createHandle();
        while (true) {
            if (this.activeCollectionStorage.size() >= 2000) {
                logger.log(Level.WARNING, "Instrument " + this.instrument.getName() + " has exceeded the maximum allowed accumulations (" + 2000 + ").");
                return NOOP_STORAGE_HANDLE;
            }
            AggregatorHandle<T> boundAggregatorHandle = this.activeCollectionStorage.putIfAbsent(attributes, aggregatorHandle);
            if (boundAggregatorHandle == null) break;
            if (boundAggregatorHandle.acquire()) {
                return boundAggregatorHandle;
            }
            this.activeCollectionStorage.remove(attributes, boundAggregatorHandle);
        }
        return aggregatorHandle;
    }

    public synchronized Map<Attributes, T> collectFor(CollectionHandle collector, Set<CollectionHandle> collectors, boolean suppressCollection) {
        if (!suppressCollection) {
            this.collectSynchronousDeltaAccumulationAndReset();
        }
        HashMap result = new HashMap();
        for (DeltaAccumulation<T> point : this.unreportedDeltas) {
            if (point.wasReadBy(collector)) continue;
            MetricStorageUtils.mergeInPlace(result, point.read(collector), this.aggregator);
        }
        this.unreportedDeltas.removeIf(delta -> delta.wasReadByAll(collectors));
        return result;
    }

    private synchronized void collectSynchronousDeltaAccumulationAndReset() {
        HashMap<Attributes, T> result = new HashMap<Attributes, T>();
        for (Map.Entry<Attributes, AggregatorHandle<T>> entry : this.activeCollectionStorage.entrySet()) {
            T accumulation;
            boolean unmappedEntry = entry.getValue().tryUnmap();
            if (unmappedEntry) {
                this.activeCollectionStorage.remove(entry.getKey(), entry.getValue());
            }
            if ((accumulation = entry.getValue().accumulateThenReset(entry.getKey())) == null) continue;
            result.put(entry.getKey(), accumulation);
        }
        if (!result.isEmpty()) {
            this.unreportedDeltas.add(new DeltaAccumulation(result));
        }
    }

    private static class NoopBoundHandle
    implements BoundStorageHandle {
        private NoopBoundHandle() {
        }

        @Override
        public void recordLong(long value, Attributes attributes, Context context) {
        }

        @Override
        public void recordDouble(double value, Attributes attributes, Context context) {
        }

        @Override
        public void release() {
        }
    }
}

