/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.data.DoubleExemplarData;
import io.opentelemetry.sdk.metrics.data.MetricData;
import io.opentelemetry.sdk.metrics.internal.aggregator.Aggregator;
import io.opentelemetry.sdk.metrics.internal.aggregator.AggregatorHandle;
import io.opentelemetry.sdk.metrics.internal.aggregator.DoubleExponentialHistogramBuckets;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialBucketStrategy;
import io.opentelemetry.sdk.metrics.internal.aggregator.ExponentialHistogramAccumulation;
import io.opentelemetry.sdk.metrics.internal.aggregator.MetricDataUtils;
import io.opentelemetry.sdk.metrics.internal.data.ImmutableMetricData;
import io.opentelemetry.sdk.metrics.internal.data.exponentialhistogram.ExponentialHistogramData;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.metrics.internal.exemplar.ExemplarReservoir;
import io.opentelemetry.sdk.metrics.internal.state.ExponentialCounterFactory;
import io.opentelemetry.sdk.resources.Resource;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;

public final class DoubleExponentialHistogramAggregator
implements Aggregator<ExponentialHistogramAccumulation, DoubleExemplarData> {
    private final Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier;
    private final ExponentialBucketStrategy bucketStrategy;

    public DoubleExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, int maxBuckets) {
        this(reservoirSupplier, ExponentialBucketStrategy.newStrategy(maxBuckets, ExponentialCounterFactory.circularBufferCounter()));
    }

    DoubleExponentialHistogramAggregator(Supplier<ExemplarReservoir<DoubleExemplarData>> reservoirSupplier, ExponentialBucketStrategy bucketStrategy) {
        this.reservoirSupplier = reservoirSupplier;
        this.bucketStrategy = bucketStrategy;
    }

    @Override
    public AggregatorHandle<ExponentialHistogramAccumulation, DoubleExemplarData> createHandle() {
        return new Handle(this.reservoirSupplier.get(), this.bucketStrategy);
    }

    @Override
    public ExponentialHistogramAccumulation merge(ExponentialHistogramAccumulation previous, ExponentialHistogramAccumulation current) {
        DoubleExponentialHistogramBuckets posBuckets = DoubleExponentialHistogramAggregator.merge(previous.getPositiveBuckets(), current.getPositiveBuckets());
        DoubleExponentialHistogramBuckets negBuckets = DoubleExponentialHistogramAggregator.merge(previous.getNegativeBuckets(), current.getNegativeBuckets());
        int commonScale = Math.min(posBuckets.getScale(), negBuckets.getScale());
        posBuckets.downscale(posBuckets.getScale() - commonScale);
        negBuckets.downscale(negBuckets.getScale() - commonScale);
        double min = -1.0;
        double max = -1.0;
        if (previous.hasMinMax() && current.hasMinMax()) {
            min = Math.min(previous.getMin(), current.getMin());
            max = Math.max(previous.getMax(), current.getMax());
        } else if (previous.hasMinMax()) {
            min = previous.getMin();
            max = previous.getMax();
        } else if (current.hasMinMax()) {
            min = current.getMin();
            max = current.getMax();
        }
        return ExponentialHistogramAccumulation.create(commonScale, previous.getSum() + current.getSum(), previous.hasMinMax() || current.hasMinMax(), min, max, posBuckets, negBuckets, previous.getZeroCount() + current.getZeroCount(), current.getExemplars());
    }

    private static DoubleExponentialHistogramBuckets merge(DoubleExponentialHistogramBuckets a, DoubleExponentialHistogramBuckets b) {
        if (b.getTotalCount() == 0L) {
            return a;
        }
        if (a.getTotalCount() == 0L) {
            return b;
        }
        a.mergeInto(b);
        return a;
    }

    @Override
    public MetricData toMetricData(Resource resource, InstrumentationScopeInfo instrumentationScopeInfo, MetricDescriptor metricDescriptor, Map<Attributes, ExponentialHistogramAccumulation> accumulationByLabels, AggregationTemporality temporality, long startEpochNanos, long lastCollectionEpoch, long epochNanos) {
        return ImmutableMetricData.createExponentialHistogram(resource, instrumentationScopeInfo, metricDescriptor.getName(), metricDescriptor.getDescription(), metricDescriptor.getSourceInstrument().getUnit(), ExponentialHistogramData.create(temporality, MetricDataUtils.toExponentialHistogramPointList(accumulationByLabels, temporality == AggregationTemporality.CUMULATIVE ? startEpochNanos : lastCollectionEpoch, epochNanos)));
    }

    static final class Handle
    extends AggregatorHandle<ExponentialHistogramAccumulation, DoubleExemplarData> {
        private final DoubleExponentialHistogramBuckets positiveBuckets;
        private final DoubleExponentialHistogramBuckets negativeBuckets;
        private long zeroCount = 0L;
        private double sum = 0.0;
        private double min = Double.MAX_VALUE;
        private double max = -1.0;
        private long count = 0L;

        Handle(ExemplarReservoir<DoubleExemplarData> reservoir, ExponentialBucketStrategy bucketStrategy) {
            super(reservoir);
            this.positiveBuckets = bucketStrategy.newBuckets();
            this.negativeBuckets = bucketStrategy.newBuckets();
        }

        @Override
        protected synchronized ExponentialHistogramAccumulation doAccumulateThenReset(List<DoubleExemplarData> exemplars) {
            ExponentialHistogramAccumulation acc = ExponentialHistogramAccumulation.create(this.positiveBuckets.getScale(), this.sum, this.count > 0L, this.count > 0L ? this.min : -1.0, this.count > 0L ? this.max : -1.0, this.positiveBuckets.copy(), this.negativeBuckets.copy(), this.zeroCount, exemplars);
            this.sum = 0.0;
            this.zeroCount = 0L;
            this.min = Double.MAX_VALUE;
            this.max = -1.0;
            this.count = 0L;
            this.positiveBuckets.clear();
            this.negativeBuckets.clear();
            return acc;
        }

        @Override
        protected synchronized void doRecordDouble(double value) {
            DoubleExponentialHistogramBuckets buckets;
            if (!Double.isFinite(value)) {
                return;
            }
            this.sum += value;
            this.min = Math.min(this.min, value);
            this.max = Math.max(this.max, value);
            ++this.count;
            int c = Double.compare(value, 0.0);
            if (c == 0) {
                ++this.zeroCount;
                return;
            }
            DoubleExponentialHistogramBuckets doubleExponentialHistogramBuckets = buckets = c > 0 ? this.positiveBuckets : this.negativeBuckets;
            if (!buckets.record(value)) {
                this.downScale(buckets.getScaleReduction(value));
                buckets.record(value);
            }
        }

        @Override
        protected void doRecordLong(long value) {
            this.doRecordDouble(value);
        }

        void downScale(int by) {
            this.positiveBuckets.downscale(by);
            this.negativeBuckets.downscale(by);
        }
    }
}

