/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.data;

import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.sdk.metrics.data.DoubleHistogramPointData;
import io.opentelemetry.sdk.metrics.data.Exemplar;
import java.util.List;

final class AutoValue_DoubleHistogramPointData
extends DoubleHistogramPointData {
    private final long startEpochNanos;
    private final long epochNanos;
    private final Attributes attributes;
    private final List<Exemplar> exemplars;
    private final double sum;
    private final long count;
    private final List<Double> boundaries;
    private final List<Long> counts;

    AutoValue_DoubleHistogramPointData(long startEpochNanos, long epochNanos, Attributes attributes, List<Exemplar> exemplars, double sum, long count, List<Double> boundaries, List<Long> counts) {
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        if (attributes == null) {
            throw new NullPointerException("Null attributes");
        }
        this.attributes = attributes;
        if (exemplars == null) {
            throw new NullPointerException("Null exemplars");
        }
        this.exemplars = exemplars;
        this.sum = sum;
        this.count = count;
        if (boundaries == null) {
            throw new NullPointerException("Null boundaries");
        }
        this.boundaries = boundaries;
        if (counts == null) {
            throw new NullPointerException("Null counts");
        }
        this.counts = counts;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public List<Exemplar> getExemplars() {
        return this.exemplars;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public List<Double> getBoundaries() {
        return this.boundaries;
    }

    @Override
    public List<Long> getCounts() {
        return this.counts;
    }

    public String toString() {
        return "DoubleHistogramPointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", exemplars=" + this.exemplars + ", sum=" + this.sum + ", count=" + this.count + ", boundaries=" + this.boundaries + ", counts=" + this.counts + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DoubleHistogramPointData) {
            DoubleHistogramPointData that = (DoubleHistogramPointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && this.exemplars.equals(that.getExemplars()) && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.count == that.getCount() && this.boundaries.equals(that.getBoundaries()) && this.counts.equals(that.getCounts());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        h$ *= 1000003;
        h$ ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        h$ *= 1000003;
        h$ ^= this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.exemplars.hashCode();
        h$ *= 1000003;
        h$ ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        h$ *= 1000003;
        h$ ^= (int)(this.count >>> 32 ^ this.count);
        h$ *= 1000003;
        h$ ^= this.boundaries.hashCode();
        h$ *= 1000003;
        return h$ ^= this.counts.hashCode();
    }
}

