/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.metrics.internal.aggregator;

import io.opentelemetry.sdk.common.InstrumentationLibraryInfo;
import io.opentelemetry.sdk.metrics.common.InstrumentDescriptor;
import io.opentelemetry.sdk.metrics.common.InstrumentType;
import io.opentelemetry.sdk.metrics.data.AggregationTemporality;
import io.opentelemetry.sdk.metrics.internal.aggregator.AbstractAggregator;
import io.opentelemetry.sdk.metrics.internal.descriptor.MetricDescriptor;
import io.opentelemetry.sdk.resources.Resource;

abstract class AbstractSumAggregator<T>
extends AbstractAggregator<T> {
    private final boolean isMonotonic;
    private final AggregationTemporality temporality;
    private final MergeStrategy mergeStrategy;

    AbstractSumAggregator(Resource resource, InstrumentationLibraryInfo instrumentationLibraryInfo, InstrumentDescriptor instrumentDescriptor, MetricDescriptor metricDescriptor, AggregationTemporality temporality) {
        super(resource, instrumentationLibraryInfo, metricDescriptor, AbstractSumAggregator.resolveStateful(instrumentDescriptor.getType(), temporality));
        InstrumentType type = instrumentDescriptor.getType();
        this.isMonotonic = type == InstrumentType.COUNTER || type == InstrumentType.OBSERVABLE_SUM;
        this.temporality = temporality;
        this.mergeStrategy = AbstractSumAggregator.resolveMergeStrategy(type, temporality);
    }

    private static boolean resolveStateful(InstrumentType instrumentType, AggregationTemporality temporality) {
        if (instrumentType == InstrumentType.OBSERVABLE_SUM || instrumentType == InstrumentType.OBSERVABLE_UP_DOWN_SUM) {
            return temporality == AggregationTemporality.DELTA;
        }
        return temporality == AggregationTemporality.CUMULATIVE;
    }

    static MergeStrategy resolveMergeStrategy(InstrumentType instrumentType, AggregationTemporality temporality) {
        if ((instrumentType == InstrumentType.OBSERVABLE_SUM || instrumentType == InstrumentType.OBSERVABLE_UP_DOWN_SUM) && temporality == AggregationTemporality.DELTA) {
            return MergeStrategy.DIFF;
        }
        return MergeStrategy.SUM;
    }

    @Override
    public final T merge(T previousAccumulation, T accumulation) {
        switch (this.mergeStrategy) {
            case SUM: {
                return this.mergeSum(previousAccumulation, accumulation);
            }
            case DIFF: {
                return this.mergeDiff(previousAccumulation, accumulation);
            }
        }
        throw new IllegalStateException("Unsupported merge strategy: " + this.mergeStrategy.name());
    }

    abstract T mergeSum(T var1, T var2);

    abstract T mergeDiff(T var1, T var2);

    final boolean isMonotonic() {
        return this.isMonotonic;
    }

    final AggregationTemporality temporality() {
        return this.temporality;
    }

    static enum MergeStrategy {
        SUM,
        DIFF;

    }
}

