/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.api.metrics.LongUpDownCounter;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.sdk.internal.SemConvAttributes;
import io.opentelemetry.sdk.trace.samplers.SamplingDecision;
import java.util.function.Supplier;
import javax.annotation.Nullable;

final class SdkTracerInstrumentation {
    private static final Attributes noParentDrop = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"none", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.DROP.name());
    private static final Attributes noParentRecordOnly = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"none", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_ONLY.name());
    private static final Attributes noParentRecordAndSample = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"none", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_AND_SAMPLE.name());
    private static final Attributes remoteParentDrop = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"remote", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.DROP.name());
    private static final Attributes remoteParentRecordOnly = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"remote", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_ONLY.name());
    private static final Attributes remoteParentRecordAndSample = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"remote", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_AND_SAMPLE.name());
    private static final Attributes localParentDrop = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"local", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.DROP.name());
    private static final Attributes localParentRecordOnly = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"local", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_ONLY.name());
    private static final Attributes localParentRecordAndSample = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_PARENT_ORIGIN, (Object)"local", (AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_AND_SAMPLE.name());
    private static final Attributes recordOnly = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_ONLY.name());
    private static final Attributes recordAndSample = Attributes.of((AttributeKey)SemConvAttributes.OTEL_SPAN_SAMPLING_RESULT, (Object)SamplingDecision.RECORD_AND_SAMPLE.name());
    private final Object lock = new Object();
    private final Supplier<MeterProvider> meterProvider;
    @Nullable
    private Meter meter;
    @Nullable
    private volatile LongCounter startedSpans;
    @Nullable
    private volatile LongUpDownCounter liveSpans;

    SdkTracerInstrumentation(Supplier<MeterProvider> meterProvider) {
        this.meterProvider = meterProvider;
    }

    Runnable startSpan(SpanContext parentSpanContext, SamplingDecision samplingDecision) {
        if (!parentSpanContext.isValid()) {
            switch (samplingDecision) {
                case DROP: {
                    this.startedSpans().add(1L, noParentDrop);
                    return SdkTracerInstrumentation::noop;
                }
                case RECORD_ONLY: {
                    this.startedSpans().add(1L, noParentRecordOnly);
                    this.liveSpans().add(1L, recordOnly);
                    return this::decrementRecordOnly;
                }
                case RECORD_AND_SAMPLE: {
                    this.startedSpans().add(1L, noParentRecordAndSample);
                    this.liveSpans().add(1L, recordAndSample);
                    return this::decrementRecordAndSample;
                }
            }
            throw new IllegalArgumentException("Unrecognized sampling decision: " + (Object)((Object)samplingDecision));
        }
        if (parentSpanContext.isRemote()) {
            switch (samplingDecision) {
                case DROP: {
                    this.startedSpans().add(1L, remoteParentDrop);
                    return SdkTracerInstrumentation::noop;
                }
                case RECORD_ONLY: {
                    this.startedSpans().add(1L, remoteParentRecordOnly);
                    this.liveSpans().add(1L, recordOnly);
                    return this::decrementRecordOnly;
                }
                case RECORD_AND_SAMPLE: {
                    this.startedSpans().add(1L, remoteParentRecordAndSample);
                    this.liveSpans().add(1L, recordAndSample);
                    return this::decrementRecordAndSample;
                }
            }
            throw new IllegalArgumentException("Unrecognized sampling decision: " + (Object)((Object)samplingDecision));
        }
        switch (samplingDecision) {
            case DROP: {
                this.startedSpans().add(1L, localParentDrop);
                return SdkTracerInstrumentation::noop;
            }
            case RECORD_ONLY: {
                this.startedSpans().add(1L, localParentRecordOnly);
                this.liveSpans().add(1L, recordOnly);
                return this::decrementRecordOnly;
            }
            case RECORD_AND_SAMPLE: {
                this.startedSpans().add(1L, localParentRecordAndSample);
                this.liveSpans().add(1L, recordAndSample);
                return this::decrementRecordAndSample;
            }
        }
        throw new IllegalArgumentException("Unrecognized sampling decision: " + (Object)((Object)samplingDecision));
    }

    private static void noop() {
    }

    private void decrementRecordOnly() {
        this.liveSpans().add(-1L, recordOnly);
    }

    private void decrementRecordAndSample() {
        this.liveSpans().add(-1L, recordAndSample);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongCounter startedSpans() {
        LongCounter startedSpans = this.startedSpans;
        if (startedSpans == null) {
            Object object = this.lock;
            synchronized (object) {
                startedSpans = this.startedSpans;
                if (startedSpans == null) {
                    this.startedSpans = startedSpans = this.meter().counterBuilder("otel.sdk.span.started").setUnit("{span}").setDescription("The number of created spans.").build();
                }
            }
        }
        return startedSpans;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LongUpDownCounter liveSpans() {
        LongUpDownCounter liveSpans = this.liveSpans;
        if (liveSpans == null) {
            Object object = this.lock;
            synchronized (object) {
                liveSpans = this.liveSpans;
                if (liveSpans == null) {
                    this.liveSpans = liveSpans = this.meter().upDownCounterBuilder("otel.sdk.span.live").setUnit("{span}").setDescription("The number of created spans with recording=true for which the end operation has not been called yet.").build();
                }
            }
        }
        return liveSpans;
    }

    private Meter meter() {
        if (this.meter == null) {
            this.meter = this.meterProvider.get().get("io.opentelemetry.sdk.trace");
        }
        return this.meter;
    }
}

