/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.api.metrics.MeterProvider;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.InstrumentationScopeInfo;
import io.opentelemetry.sdk.internal.ExceptionAttributeResolver;
import io.opentelemetry.sdk.internal.ScopeConfigurator;
import io.opentelemetry.sdk.internal.ScopeConfiguratorBuilder;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.trace.IdGenerator;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SpanLimits;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.internal.TracerConfig;
import io.opentelemetry.sdk.trace.samplers.Sampler;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;

public final class SdkTracerProviderBuilder {
    private static final Sampler DEFAULT_SAMPLER = Sampler.parentBased(Sampler.alwaysOn());
    private final List<SpanProcessor> spanProcessors = new ArrayList<SpanProcessor>();
    private Clock clock = Clock.getDefault();
    private IdGenerator idsGenerator = IdGenerator.random();
    private Resource resource = Resource.getDefault();
    private Supplier<SpanLimits> spanLimitsSupplier = SpanLimits::getDefault;
    private Sampler sampler = DEFAULT_SAMPLER;
    private ScopeConfiguratorBuilder<TracerConfig> tracerConfiguratorBuilder = TracerConfig.configuratorBuilder();
    private ExceptionAttributeResolver exceptionAttributeResolver = ExceptionAttributeResolver.getDefault();
    private Supplier<MeterProvider> meterProvider = MeterProvider::noop;

    public SdkTracerProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkTracerProviderBuilder setIdGenerator(IdGenerator idGenerator) {
        Objects.requireNonNull(idGenerator, "idGenerator");
        this.idsGenerator = idGenerator;
        return this;
    }

    public SdkTracerProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkTracerProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(SpanLimits spanLimits) {
        Objects.requireNonNull(spanLimits, "spanLimits");
        this.spanLimitsSupplier = () -> spanLimits;
        return this;
    }

    public SdkTracerProviderBuilder setSpanLimits(Supplier<SpanLimits> spanLimitsSupplier) {
        Objects.requireNonNull(spanLimitsSupplier, "spanLimitsSupplier");
        this.spanLimitsSupplier = spanLimitsSupplier;
        return this;
    }

    public SdkTracerProviderBuilder setSampler(Sampler sampler) {
        Objects.requireNonNull(sampler, "sampler");
        this.sampler = sampler;
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessor(SpanProcessor spanProcessor) {
        Objects.requireNonNull(spanProcessor, "spanProcessor");
        this.spanProcessors.add(spanProcessor);
        return this;
    }

    public SdkTracerProviderBuilder addSpanProcessorFirst(SpanProcessor spanProcessor) {
        Objects.requireNonNull(spanProcessor, "spanProcessor");
        this.spanProcessors.add(0, spanProcessor);
        return this;
    }

    SdkTracerProviderBuilder setTracerConfigurator(ScopeConfigurator<TracerConfig> tracerConfigurator) {
        this.tracerConfiguratorBuilder = tracerConfigurator.toBuilder();
        return this;
    }

    SdkTracerProviderBuilder addTracerConfiguratorCondition(Predicate<InstrumentationScopeInfo> scopeMatcher, TracerConfig tracerConfig) {
        this.tracerConfiguratorBuilder.addCondition(scopeMatcher, (Object)tracerConfig);
        return this;
    }

    SdkTracerProviderBuilder setExceptionAttributeResolver(ExceptionAttributeResolver exceptionAttributeResolver) {
        Objects.requireNonNull(exceptionAttributeResolver, "exceptionAttributeResolver");
        this.exceptionAttributeResolver = exceptionAttributeResolver;
        return this;
    }

    public SdkTracerProviderBuilder setMeterProvider(Supplier<MeterProvider> meterProvider) {
        Objects.requireNonNull(meterProvider, "meterProvider");
        this.meterProvider = meterProvider;
        return this;
    }

    public SdkTracerProvider build() {
        return new SdkTracerProvider(this.clock, this.idsGenerator, this.resource, this.spanLimitsSupplier, this.sampler, this.spanProcessors, (ScopeConfigurator<TracerConfig>)this.tracerConfiguratorBuilder.build(), this.exceptionAttributeResolver, this.meterProvider);
    }

    SdkTracerProviderBuilder() {
    }
}

