/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.common.AttributeConsumer;
import io.opentelemetry.common.AttributeKey;
import io.opentelemetry.common.Attributes;
import io.opentelemetry.common.ReadableAttributes;
import java.util.HashMap;
import java.util.Map;

final class AttributesMap
implements ReadableAttributes {
    private final Map<AttributeKey, Object> data = new HashMap<AttributeKey, Object>();
    private final long capacity;
    private int totalAddedValues = 0;

    AttributesMap(long capacity) {
        this.capacity = capacity;
    }

    public <T> void put(AttributeKey<T> key, T value) {
        if (key == null || key.getKey() == null || value == null) {
            return;
        }
        ++this.totalAddedValues;
        if ((long)this.data.size() >= this.capacity && !this.data.containsKey(key)) {
            return;
        }
        this.data.put(key, value);
    }

    void remove(AttributeKey key) {
        this.data.remove(key);
    }

    int getTotalAddedValues() {
        return this.totalAddedValues;
    }

    public <T> T get(AttributeKey<T> key) {
        return (T)this.data.get(key);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    public void forEach(AttributeConsumer consumer) {
        for (Map.Entry<AttributeKey, Object> entry : this.data.entrySet()) {
            AttributeKey key = entry.getKey();
            Object value = entry.getValue();
            consumer.consume(key, value);
        }
    }

    public String toString() {
        return "AttributesMap{data=" + this.data + ", capacity=" + this.capacity + ", totalAddedValues=" + this.totalAddedValues + '}';
    }

    ReadableAttributes immutableCopy() {
        Attributes.Builder builder = Attributes.newBuilder();
        for (Map.Entry<AttributeKey, Object> entry : this.data.entrySet()) {
            builder.setAttribute(entry.getKey(), entry.getValue());
        }
        return builder.build();
    }
}

