/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveSpan;
import io.opentracing.Scope;
import io.opentracing.ScopeManager;
import java.util.ArrayDeque;
import java.util.Deque;

public final class BraveScopeManager
implements ScopeManager {
    final ThreadLocal<Deque<BraveScope>> currentScopes = new ThreadLocal<Deque<BraveScope>>(){

        @Override
        protected Deque<BraveScope> initialValue() {
            return new ArrayDeque<BraveScope>();
        }
    };
    private final Tracer tracer;

    BraveScopeManager(Tracing tracing) {
        this.tracer = tracing.tracer();
    }

    public Scope active() {
        final BraveSpan span = this.currentSpan();
        if (span == null) {
            return null;
        }
        return new Scope(){

            public void close() {
            }

            public io.opentracing.Span span() {
                return span;
            }
        };
    }

    BraveSpan currentSpan() {
        BraveScope scope = this.currentScopes.get().peekFirst();
        if (scope != null) {
            return scope.span();
        }
        Span braveSpan = this.tracer.currentSpan();
        if (braveSpan != null) {
            return new BraveSpan(this.tracer, braveSpan);
        }
        return null;
    }

    public BraveScope activate(io.opentracing.Span span, boolean finishSpanOnClose) {
        if (span == null) {
            return null;
        }
        if (!(span instanceof BraveSpan)) {
            throw new IllegalArgumentException("Span must be an instance of brave.opentracing.BraveSpan, but was " + span.getClass());
        }
        return this.newScope((BraveSpan)span, finishSpanOnClose);
    }

    BraveScope newScope(BraveSpan span, boolean finishSpanOnClose) {
        BraveScope result = new BraveScope(this, this.tracer.withSpanInScope(span.delegate), span, finishSpanOnClose);
        this.currentScopes.get().addFirst(result);
        return result;
    }

    void deregister(BraveScope span) {
        this.currentScopes.get().remove(span);
    }
}

