/*
 * Decompiled with CFR 0.152.
 */
package brave.opentracing;

import brave.Span;
import brave.Tracer;
import brave.Tracing;
import brave.baggage.BaggagePropagation;
import brave.opentracing.BraveScope;
import brave.opentracing.BraveScopeManager;
import brave.opentracing.BraveSpan;
import brave.opentracing.BraveSpanBuilder;
import brave.opentracing.BraveSpanContext;
import brave.opentracing.OpenTracingVersion;
import brave.opentracing.TextMapPropagation;
import brave.propagation.B3SingleFormat;
import brave.propagation.Propagation;
import brave.propagation.TraceContext;
import brave.propagation.TraceContextOrSamplingFlags;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.propagation.BinaryExtract;
import io.opentracing.propagation.BinaryInject;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMap;
import io.opentracing.propagation.TextMapExtract;
import io.opentracing.propagation.TextMapInject;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;

public final class BraveTracer
implements io.opentracing.Tracer {
    final Tracing tracing;
    final Tracer delegate;
    final BraveScopeManager scopeManager;
    final Map<Format<?>, TraceContext.Injector<TextMapInject>> formatToInjector = new LinkedHashMap();
    final Map<Format<?>, TraceContext.Injector<TextMapInject>> formatToClientInjector = new LinkedHashMap();
    final Map<Format<?>, TraceContext.Injector<TextMapInject>> formatToProducerInjector = new LinkedHashMap();
    final Map<Format<?>, TraceContext.Injector<TextMapInject>> formatToConsumerInjector = new LinkedHashMap();
    final Map<Format<?>, TraceContext.Extractor<TextMapExtract>> formatToExtractor = new LinkedHashMap();

    public static BraveTracer create(Tracing brave4) {
        return BraveTracer.newBuilder(brave4).build();
    }

    public static Builder newBuilder(Tracing brave4) {
        try {
            OpenTracingVersion.get();
        }
        catch (ExceptionInInitializerError e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw e;
        }
        return new Builder(brave4);
    }

    BraveTracer(Builder b) {
        this.tracing = b.tracing;
        this.delegate = b.tracing.tracer();
        this.scopeManager = OpenTracingVersion.get().scopeManager(b.tracing);
        LinkedHashSet<String> lcPropagationKeys = new LinkedHashSet<String>();
        for (String string : BaggagePropagation.allKeyNames((Propagation)this.tracing.propagation())) {
            lcPropagationKeys.add(string.toLowerCase(Locale.ROOT));
        }
        for (Map.Entry entry : b.formatToPropagation.entrySet()) {
            this.formatToInjector.put((Format)entry.getKey(), (TraceContext.Injector<TextMapInject>)((Propagation)entry.getValue()).injector(TextMapPropagation.SETTER));
            this.formatToClientInjector.put((Format)entry.getKey(), (TraceContext.Injector<TextMapInject>)((Propagation)entry.getValue()).injector((Propagation.Setter)TextMapPropagation.REMOTE_SETTER.CLIENT));
            this.formatToProducerInjector.put((Format)entry.getKey(), (TraceContext.Injector<TextMapInject>)((Propagation)entry.getValue()).injector((Propagation.Setter)TextMapPropagation.REMOTE_SETTER.PRODUCER));
            this.formatToConsumerInjector.put((Format)entry.getKey(), (TraceContext.Injector<TextMapInject>)((Propagation)entry.getValue()).injector((Propagation.Setter)TextMapPropagation.REMOTE_SETTER.CONSUMER));
            this.formatToExtractor.put((Format)entry.getKey(), new TextMapPropagation.TextMapExtractor((Propagation<String>)((Propagation)entry.getValue()), lcPropagationKeys, TextMapPropagation.GETTER));
        }
        for (Propagation propagation : b.formatToPropagation.values()) {
            this.formatToInjector.put(Format.Builtin.TEXT_MAP_INJECT, (TraceContext.Injector<TextMapInject>)propagation.injector(TextMapPropagation.SETTER));
            this.formatToClientInjector.put(Format.Builtin.TEXT_MAP_INJECT, (TraceContext.Injector<TextMapInject>)propagation.injector((Propagation.Setter)TextMapPropagation.REMOTE_SETTER.CLIENT));
            this.formatToProducerInjector.put(Format.Builtin.TEXT_MAP_INJECT, (TraceContext.Injector<TextMapInject>)propagation.injector((Propagation.Setter)TextMapPropagation.REMOTE_SETTER.PRODUCER));
            this.formatToConsumerInjector.put(Format.Builtin.TEXT_MAP_INJECT, (TraceContext.Injector<TextMapInject>)propagation.injector((Propagation.Setter)TextMapPropagation.REMOTE_SETTER.CONSUMER));
            this.formatToExtractor.put(Format.Builtin.TEXT_MAP_EXTRACT, new TextMapPropagation.TextMapExtractor((Propagation<String>)propagation, lcPropagationKeys, TextMapPropagation.GETTER));
        }
    }

    public Tracing unwrap() {
        return this.tracing;
    }

    public BraveScopeManager scopeManager() {
        return this.scopeManager;
    }

    public BraveSpan activeSpan() {
        return this.scopeManager.activeSpan();
    }

    public BraveScope activateSpan(Span span) {
        return this.scopeManager.activate(span);
    }

    public BraveSpanBuilder buildSpan(String operationName) {
        return OpenTracingVersion.get().spanBuilder(this, operationName);
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        BraveSpanContext braveContext = (BraveSpanContext)spanContext;
        if (carrier instanceof BinaryInject) {
            BinaryCodec.INSTANCE.inject(braveContext.unwrap(), (BinaryInject)carrier);
            return;
        }
        if (!(carrier instanceof TextMapInject)) {
            throw new UnsupportedOperationException(carrier + " not instanceof TextMapInject");
        }
        Span.Kind kind = braveContext.kind;
        TraceContext.Injector<TextMapInject> injector = null;
        if (Span.Kind.CLIENT.equals((Object)kind)) {
            injector = this.formatToClientInjector.get(format);
        } else if (Span.Kind.PRODUCER.equals((Object)kind)) {
            injector = this.formatToProducerInjector.get(format);
        } else if (Span.Kind.CONSUMER.equals((Object)kind)) {
            injector = this.formatToConsumerInjector.get(format);
        }
        if (injector == null) {
            injector = this.formatToInjector.get(format);
        }
        if (injector == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToInjector.keySet());
        }
        injector.inject(braveContext.unwrap(), (Object)((TextMapInject)carrier));
    }

    public <C> BraveSpanContext extract(Format<C> format, C carrier) {
        if (carrier instanceof BinaryExtract) {
            return BraveSpanContext.create(BinaryCodec.INSTANCE.extract((BinaryExtract)carrier));
        }
        TraceContext.Extractor<TextMapExtract> extractor = this.formatToExtractor.get(format);
        if (extractor == null) {
            throw new UnsupportedOperationException(format + " not in " + this.formatToExtractor.keySet());
        }
        TraceContextOrSamplingFlags extractionResult = extractor.extract(carrier);
        return BraveSpanContext.create(extractionResult);
    }

    public void close() {
        this.tracing.close();
    }

    public static final class Builder {
        Tracing tracing;
        Map<Format<TextMap>, Propagation<String>> formatToPropagation = new LinkedHashMap<Format<TextMap>, Propagation<String>>();

        Builder(Tracing tracing) {
            if (tracing == null) {
                throw new NullPointerException("brave tracing component == null");
            }
            this.tracing = tracing;
            this.formatToPropagation.put((Format<TextMap>)Format.Builtin.HTTP_HEADERS, (Propagation<String>)tracing.propagation());
            this.formatToPropagation.put((Format<TextMap>)Format.Builtin.TEXT_MAP, (Propagation<String>)tracing.propagation());
        }

        public Builder textMapPropagation(Format<TextMap> format, Propagation<String> propagation) {
            if (format == null) {
                throw new NullPointerException("format == null");
            }
            if (propagation == null) {
                throw new NullPointerException("propagation == null");
            }
            this.formatToPropagation.put(format, propagation);
            return this;
        }

        public BraveTracer build() {
            return new BraveTracer(this);
        }
    }

    static enum BinaryCodec implements TraceContext.Injector<BinaryInject>,
    TraceContext.Extractor<BinaryExtract>
    {
        INSTANCE;

        final Charset ascii = Charset.forName("US-ASCII");

        public TraceContextOrSamplingFlags extract(BinaryExtract binaryExtract) {
            try {
                return B3SingleFormat.parseB3SingleFormat((CharSequence)this.ascii.decode(binaryExtract.extractionBuffer()));
            }
            catch (RuntimeException e) {
                return TraceContextOrSamplingFlags.EMPTY;
            }
        }

        public void inject(TraceContext traceContext, BinaryInject binaryInject) {
            byte[] injected = B3SingleFormat.writeB3SingleFormatAsBytes((TraceContext)traceContext);
            binaryInject.injectionBuffer(injected.length).put(injected);
        }
    }
}

